(function(window, document){
	var defKey = '小时代 txt';
	
	$('#pan_key').on('keyup', function(e){
		if(e.keyCode == 13){
			$('#pan_btn').trigger('click');
		}
	}).val(config('pan_key', defKey));
	
	$('#pan_search').on('click', function(){
		$('#pan_key').get(0).focus()
	});
	
	var threadId = 0;
	$('#pan_btn').on('click', function(){
		var key = $.trim($('#pan_key').val());
		if(key == ''){
			alert('请输入完整的关键词进行搜索');
		}
		config('pan_key', key, true);
		if(threadId >0 ){
			$e.stop(threadId);
		}
		var $tpl_list = window.mzTpl('tpl_list'),
			$tpl_count = window.mzTpl('tpl_count');
		$('#pan_list').html('').prepend($tpl_count({}));
		threadId = $e.run({
				_name   : 'search_pan', 
				_file   : 'search.dst', 
				action  : 'search',
				key     : key,
				_runecho: function(handle, skey){
					var arr = skey.substring(1).split(/\|\|/ig);
					if(skey.search(/:/g) != 0){
						debugtime(skey);
						return;
					}
					
					var opts = {
						url   : arr[0],
						title : arr[1],
						size  : arr[2],
						md5   : $e.md5(arr[0]),
						author: '',
						type  : ''
					};
					$('#pan_count').html($('#pan_list > .line').length);
					$('#pan_list').append($tpl_list(opts));
				},
				_runover: function(handle){
					threadId = 0
					var count = $('#pan_list > .line').length;
					$('#search_baidu .tip').hide();
					if(count > 120){
						var $end = $($('#tpl_end').html());
						$end.on('click', function(){
							$('#pan_key').select();
							$("html,body").animate({scrollTop: 0}, 400);
						});
						$('#pan_list').append($end);
					}else if(count == 0){
						$('#search_baidu .tip').html('您输的关键词没有找到结果，请换一个更精短的词吧！').show().removeClass('tip_loading');
						$('#pan_list').html('');
					}
				}
			});
	}).trigger('click');
	
	$('#tab_box').mzTab({});
	
	$('#pan_url').on('keyup', function(e){
		if(e.keyCode == 13){
			$('#pan_url_btn').trigger('click');
		}
	});
	$('#pan_url_btn').on('click', function(){
		_openThunder();
	});
	
	
	var openTxtThreads = [],openThunderThreads = [];
	window._openThunder = function (o){
		var url = $(o).data('url'),
			title = $(o).data('title'), 
			md5 = $(o).data('md5'),
			$parentNode = $('#txt_'+md5),
			openDownload = $(o).data('down') ? true: false,
			threadName = 'download_thunder_'+md5;
		if(!url){
			url = $.trim($('#pan_url').val());
			if(!url){
				art.dialog({
									id: 'downloaderror',
									lock: true,
									opacity: 0.7, // 透明度
									content: '请输入正确的百度网盘地址'
								});
				return;
			}
		}
		if(_.find(openThunderThreads, function(a){
							if(a.threadName == threadName){
								$e.stop(a.tid);
								return true;
							}
							return false;
						})){
			return false;
		}
		__log('search', 'txt_downstart_thunder', url, title);
		openThunderThreads.push({
				threadName : threadName,
				tid : $e.run({
						_name  : threadName, 
						_file  : 'search.dst', 
						url    : url,
						md5    : md5,
						title  : title,
						action : 'download',
						_runecho:function(handle, skey){
							debugtime(skey);
						},
						_showspeed:function(handle,speed, process,para){
							window.mzTip.show(speed + (process > -1 ? ', '+process + '%' : ''));
						},
						_runover2: function(handle, byStop, url){
							openThunderThreads = _.filter(openThunderThreads, function(a){
								return (a.tid != handle);
							});
							if(url.search(/^http\:/ig) > -1){
								if(openDownload){
									/*$e.backgroundRun(function(win){
										$(win.document).append('<iframe src="'+url+'"></iframe>');
									});
									*/
									$e.tabopen(url, {referer:url});
								}else{
									url = ThunderEncode(url);
									$('#thunderLink').attr('thunderHref', url).attr('thunderResTitle', title).trigger('click');
								}
							}else{
								art.dialog({
									id: 'downloaderror',
									lock: true,
									opacity: 0.7, // 透明度
									content: url
								});
								__log('search', 'txt_downfail_thunder', url);
							}
						}
					})
				});
	}
	
	window._readTxt = function (o){
		var url = $(o).data('url'),
			title = $(o).data('title'), 
			md5 = $(o).data('md5'),
			$parentNode = $('#txt_'+md5).addClass('loading'),
			threadName = 'download_txt_'+md5;
		if(_.find(openTxtThreads, function(a){
							if(a.threadName == threadName){
								$e.stop(a.tid);
								return true;
							}
							return false;
						})){
			return false;
		}
		
		window.mzTip.show(title+'：再次点击停止下载.');
		
		__log('search', 'txt_downstart_pan', url, title);

		openTxtThreads.push({
				threadName : threadName,
				tid : $e.run({
						_name  : threadName, 
						_file  : 'search_txt.dst', 
						url    : url,
						md5    : md5,
						title  : title,
						action : 'download',
						_runecho:function(handle, skey){
							if(skey.search(/error:/i) > -1){
								$parentNode.find('i').html('<font color="red">'+skey.substring(6)+"</font>");
							}else{
							}
						},
						_showspeed:function(handle,speed, process,para){
							window.mzTip.show(speed + (process > -1 ? ', '+process + '%' : ''));
							//$parentNode.find('i').html(speed + (process > -1 ? '&nbsp;&nbsp;&nbsp;'+process + '%' : ''));
						},
						_runover2: function(handle, byStop, filePath, fileTitle){
							openTxtThreads = _.filter(openTxtThreads, function(a){
								return (a.tid != handle);
							});
							$parentNode.removeClass('loading');
							if(byStop){
								window.mzTip.show(title+'：被暂停下载.');
								__log('search', 'txt_downstop', url);
								return;
							}
							if(filePath){
								window.mzTip.show('下载成功，正在导入.');
								function importBook(filePath){
									var id = $e.importBook(filePath, fileTitle);
									if(id){
										$e.tabopen('mz://reader/?url='+id, {checkExists:true});
										$parentNode.find('i').html('下载成功，导入成功.');
										window.mzTip.show('下载成功，导入成功.');
										$e.deleteFile(filePath);
										__log('search', 'txt_downsucc_pan', url);
									}else{
										window.mzTip.show('导入失败，点击重试');
										__log('search', 'txt_importfail_pan', url);
									}
								}
								importBook(filePath);
							}else{
								alert('网盘链接失效，下载失败！');
								__log('search', 'txt_downfail_pan', url);
							}
						}
					})
				});
	}
})(window, document);