﻿#ifndef REC_NOW_H_
#define REC_NOW_H_

#include <jni.h>

#ifdef __cplusplus
extern "C" {
#endif

bool RecNow_IsEnabled();

void RecNow_SetVideoQuality(int videoQuality);
const char* RecNow_GetVideoPath();
int  RecNow_GetVideoTimesMs();

int  RecNow_StartRecord();
void RecNow_StopRecord();
void RecNow_PauseRecord();
void RecNow_ResumeRecord();

void RecNow_TakeScreenshot();

void RecNow_ShowVideoStore();
void RecNow_ShowToolbar();
void RecNow_HideToolbar();

void RecNow_DeleteVideo(const char* path);
void RecNow_Playback(const char* path);
void RecNow_FastShare(const char* path);
void RecNow_ShowPlayerClub();
void RecNow_ShowWelfareCenter();

void RecNow_EnableToolbar();
void RecNow_DisableToolbar();

void RecNow_SetUploadInfo(const char* info);
void RecNow_FastUpload(const char* info);

#ifdef __cplusplus
}
#endif

#endif