/*
 * Decompiled with CFR 0.152.
 */
package net.appplus.sdk.shareplus.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.drawable.NinePatchDrawable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.appplus.sdk.e;
import net.appplus.sdk.p;

public class ImageHelper {
    private static final String TAG = ImageHelper.class.getName();
    private static Canvas canvas;
    private static ByteBuffer byteBuffer;
    private static Context context;

    public static byte[] loadNinePatch(String string, int n2, int n3) {
        Log.d((String)TAG, (String)("loadNinePatch path = " + string));
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        NinePatch ninePatch = new NinePatch(bitmap, bitmap.getNinePatchChunk(), null);
        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(context.getResources(), ninePatch);
        ninePatchDrawable.setBounds(0, 0, n2, n3);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas = new Canvas(bitmap2);
        ninePatchDrawable.draw(canvas);
        int n4 = bitmap2.getByteCount();
        byteBuffer = ByteBuffer.allocate(n4);
        bitmap2.copyPixelsToBuffer((Buffer)byteBuffer);
        bitmap2.recycle();
        Log.d((String)TAG, (String)"loadNinePatch Done");
        return byteBuffer.array();
    }

    public static int loadNinePatchLogo(String string, int n2, int n3, byte[] byArray) {
        File file = new File(string);
        if (!file.exists()) {
            Log.e((String)TAG, (String)(string + " not exists"));
            return -1;
        }
        Log.d((String)TAG, (String)("loadNinePatch path = " + string));
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        if (bitmap == null) {
            Log.e((String)TAG, (String)"decode nine patch file error");
            file.delete();
            return -1;
        }
        byte[] byArray2 = bitmap.getNinePatchChunk();
        if (byArray2 == null) {
            Log.e((String)TAG, (String)"getNinePatchChunk error");
            file.delete();
            return -1;
        }
        NinePatch ninePatch = new NinePatch(bitmap, byArray2, null);
        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(context.getResources(), ninePatch);
        ninePatchDrawable.setBounds(0, 0, n2, n3);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2 == null) {
            Log.e((String)TAG, (String)"create bitmap error");
            return -1;
        }
        canvas = new Canvas(bitmap2);
        ninePatchDrawable.draw(canvas);
        int n4 = bitmap2.getByteCount();
        byteBuffer = ByteBuffer.allocate(n4);
        bitmap2.copyPixelsToBuffer((Buffer)byteBuffer);
        bitmap2.recycle();
        System.arraycopy(byteBuffer.array(), 0, byArray, 0, n4);
        Log.d((String)TAG, (String)"loadNinePatchLogo done");
        return 0;
    }

    public static int loadNinePatchLogo(int n2, int n3, byte[] byArray) {
        String string = "/sdcard/bottom_logo.png";
        int n4 = ImageHelper.loadNinePatchLogo(string, n2, n3, byArray);
        if (-1 == n4) {
            string = context.getCacheDir().getAbsolutePath() + "/" + p.g(".png");
            n4 = ImageHelper.loadNinePatchLogo(string, n2, n3, byArray);
        }
        if (-1 == n4) {
            string = context.getFilesDir().getAbsolutePath() + "/" + p.g(".png");
            n4 = ImageHelper.loadNinePatchLogo(string, n2, n3, byArray);
        }
        return n4;
    }

    public static void setContext(Context context) {
        ImageHelper.context = context;
    }

    public static int saveImage(byte[] byArray, int n2, int n3, int n4, String string) {
        Bitmap bitmap;
        Object object;
        Log.d((String)TAG, (String)("saveImage to: " + string + ",width=" + n2 + ",height=" + n3 + ",data.length=" + byArray.length));
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.clear();
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
        if (n4 != 0) {
            object = new Matrix();
            object.postRotate((float)(-n4));
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)object, (boolean)true);
        } else {
            bitmap = bitmap2;
        }
        try {
            object = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (e.a()) {
                fileNotFoundException.printStackTrace();
            }
            return -1;
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)object);
        return 0;
    }
}

