/*
 * Decompiled with CFR 0.152.
 */
package net.appplus.sdk.shareplus;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import appplus.sharep.k.g;
import com.aipai.recnow.RecNow;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.appplus.protocols.SDcardUtils;
import net.appplus.sdk.Invoker;
import net.appplus.sdk.listener.ActionListener;
import net.appplus.sdk.shareplus.JMediaPlus;
import net.appplus.sdk.shareplus.MediaPlusActionListener;
import net.appplus.sdk.shareplus.b;
import net.appplus.sdk.shareplus.c;
import net.appplus.sdk.shareplus.d;
import net.appplus.sdk.shareplus.e;
import net.appplus.sdk.shareplus.util.ImageHelper;

public class SharePlus {
    private static final String TAG = SharePlus.class.getName();
    private static SharePlus instance;
    private Context mContext;
    private a mEventHandler;
    private ActionListener mListener = null;
    private RecNow.OnUploadCompletedListener mOnUploadCompletedListener = null;
    private JMediaPlus mMediaPlus = null;
    private appplus.sharep.i.a mDevice = null;
    private boolean mIsEnabled = false;
    private boolean mUpdateEnabled = true;
    private boolean mToolbarEnabled = true;
    private boolean mVideoStoreEnabled = true;
    private e mToolbar = null;
    private String mVideoPath = "";
    private String mPicturePath = "";
    private int mVideoQuality = 0;
    private boolean mUpdateSilent = true;
    private g mUpdater = null;
    private boolean mDebugEnabled = false;
    private b mResultListenerForSDK;
    private net.appplus.sdk.shareplus.a mResultListenerForAddon;
    private int mGameId;
    private appplus.sharep.g.a mActivityLifecycleListener;
    private int mUpdateCounts = 3;
    private RecNow.OnStartListener mOnStartListener;
    private RecNow.OnStopListener mOnStopListener;
    private RecNow.OnPauseListener mOnPauseListener;
    private RecNow.OnResumeListener mOnResumeListener;
    private RecNow.OnErrorListener mOnErrorListener;
    private RecNow.OnScreenshotListener mOnScreenshotListener;
    private RecNow.OnInitListener mOnInitListener;
    private static final int KEY_PACKAGE_NAME = 121;
    private static final int KEY_IS_DEVICE_SUPPORTED = 128;
    private static final int KEY_STRIDE = 129;
    private static final int KEY_VIDEO_PATH = 130;
    private static final int KEY_VERSION_SDK = 131;
    private static final int KEY_READ_MODE = 132;
    private static final int KEY_RAW_PATH = 133;
    private static final int KEY_TEMP_PATH = 134;
    private static final int KEY_PICTURE_PATH = 135;
    private static final int KEY_CURRENT_VIDEO_PATH = 136;
    private static final int KEY_CURRENT_PICTURE_PATH = 137;
    private static final int KEY_UPDATE_ENABLED = 149;
    private static final int KEY_TOOLBAR_ENABLED = 150;
    private static final int KEY_VIDEO_STORE_ENABLED = 151;
    private static final int KEY_VIDEO_QUALITY = 152;
    private static final int RESULT_NATIVE_INIT_COMPLETED = 341;
    private static final int ACTION_SHOW_TEST_TOOLBAR = 512;
    private static final int ACTION_DELETE_PERF_TEST_FILE = 513;
    public static final int ACTION_START_RECORD = 514;
    public static final int ACTION_STOP_RECORD = 515;
    public static final int ACTION_PAUSE_RECORD = 132;
    public static final int ACTION_RESUME_RECORD = 517;
    public static final int ACTION_REGISTER_MEDIAPLUS_RESULT_LISTENER_FOR_ADDON = 519;
    public static final int ACTION_REGISTER_MEDIAPLUS_RESULT_LISTENER_FOR_SDK = 520;

    private SharePlus() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new a(looper) : ((looper = Looper.getMainLooper()) != null ? new a(looper) : null);
    }

    public static SharePlus getInstance() {
        if (instance == null) {
            instance = new SharePlus();
        }
        return instance;
    }

    public static void setup(Application application, Bundle bundle) {
        SharePlus.setup(application, bundle, null);
    }

    public static void setup(Application application, Bundle bundle, RecNow.OnInitListener onInitListener) {
        SharePlus.getInstance()._setup(application, bundle, onInitListener);
    }

    private void _setup(Application application, Bundle bundle, RecNow.OnInitListener onInitListener) {
        Log.d((String)TAG, (String)"SharePlus::_setup");
        if (null == application || null == bundle) {
            return;
        }
        if (!(application instanceof Application)) {
            Log.e((String)TAG, (String)"context is not a instance of Application");
            return;
        }
        this.mContext = application;
        this.mOnInitListener = onInitListener;
        this.registerActivityLifecycleCallbacks(application, bundle);
        this.extractParameters(bundle);
        ImageHelper.setContext((Context)application);
        Log.d((String)TAG, (String)("CPU_ABI:" + Build.CPU_ABI));
        if (!Build.CPU_ABI.equals("armeabi-v7a")) {
            Log.e((String)TAG, (String)"only supported CPU_ABI:armeabi-v7a");
            this.showToolbar();
            return;
        }
        this.getDevice();
        SharePlus.postEventFromNative(129, 0, 0, null);
        SharePlus.postEventFromNative(70, 0, 0, null);
        SharePlus.postEventFromNative(86, 0, 0, null);
        Log.d((String)TAG, (String)"SharePlus::_setup done");
    }

    private void fetchWhiteList() {
        appplus.sharep.i.a.a(this.mContext);
    }

    private void fetchCpuMark() {
        appplus.sharep.i.a.b(this.mContext);
    }

    private void fetchLogo() {
        appplus.sharep.i.a.c(this.mContext);
    }

    private void extractParameters(Bundle bundle) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Boolean bl4 = bundle.getBoolean("hidebar", !bl);
        this.mToolbarEnabled = bl4 == false;
        this.mUpdateSilent = bundle.getBoolean("update-silent", bl2);
        this.mUpdateEnabled = bundle.getBoolean("update-enable", bl3);
        this.mDebugEnabled = bundle.getBoolean("debug-enable", false);
        this.mGameId = bundle.getInt("gameid");
    }

    public static void teardown() {
        SharePlus._nativeRelease();
    }

    private void registerActivityLifecycleCallbacks(Application application, Bundle bundle) {
        if (this.mActivityLifecycleListener == null && Build.VERSION.SDK_INT >= 14) {
            this.mActivityLifecycleListener = new appplus.sharep.g.a(bundle);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycleListener);
        }
    }

    private void unregisterActivityLifecycleCallbacks(Application application) {
        if (this.mActivityLifecycleListener != null && Build.VERSION.SDK_INT >= 14) {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycleListener);
        }
    }

    public static void onPause() {
        if (SharePlus.getInstance().isEnabled()) {
            SharePlus._nativeOnPause();
        }
    }

    public static void onResume() {
        if (SharePlus.getInstance().isEnabled()) {
            SharePlus._nativeOnResume();
        } else {
            SharePlus.getInstance().showToolbar();
        }
    }

    private void notifyAddonDeviceSupport(boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 73);
        bundle.putBoolean("device-supported", bl);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    private void onNativeInitCompleted(int n2) {
        Log.d((String)TAG, (String)("onNativeInitCompleted: " + n2));
        if (n2 == 0) {
            Log.d((String)TAG, (String)"native initialize ok");
            this.mIsEnabled = true;
        } else {
            Log.e((String)TAG, (String)("native initialize error: " + n2));
        }
        if (this.mOnInitListener != null) {
            this.mOnInitListener.onInit(n2);
        }
        SharePlus._nativeOnInit(n2);
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    private ActionListener getMediaPlusListener() {
        if (this.mListener == null) {
            this.mListener = new MediaPlusActionListener(this.getMediaPlus());
        }
        return this.mListener;
    }

    public JMediaPlus getMediaPlus() {
        if (this.mMediaPlus == null) {
            this.mMediaPlus = new JMediaPlus();
        }
        return this.mMediaPlus;
    }

    public void setVideoQuality(int n2) {
        Log.d((String)TAG, (String)("setVideoQuality:" + n2));
        this.mVideoQuality = n2;
    }

    public int getVideoQuality() {
        Log.d((String)TAG, (String)("getVideoQuality:" + this.mVideoQuality));
        return this.mVideoQuality;
    }

    public String getVideoPath() {
        return this.mVideoPath;
    }

    public String getPicturePath() {
        return this.mPicturePath;
    }

    public long getVideoTimesMs() {
        if (this.mMediaPlus != null) {
            return this.mMediaPlus.getTotalTimesMs();
        }
        return 0L;
    }

    public int startRecord() {
        if (this.mIsEnabled) {
            return this.getMediaPlus().startRecord();
        }
        return -1;
    }

    public void stopRecord() {
        if (this.mIsEnabled) {
            this.getMediaPlus().stopRecord();
        }
    }

    public void pauseRecord() {
        if (this.mIsEnabled) {
            this.getMediaPlus().pauseRecord();
        }
    }

    public void resumeRecord() {
        if (this.mIsEnabled) {
            this.getMediaPlus().resumeRecord();
        }
    }

    private appplus.sharep.i.a getDevice() {
        if (this.mContext == null) {
            return null;
        }
        if (this.mDevice == null) {
            this.mDevice = new appplus.sharep.i.a(this.mContext);
        }
        return this.mDevice;
    }

    private void registerMediaPlusActionListener() {
        Log.d((String)TAG, (String)"registerMediaPlusActionListener");
        if (!this.mIsEnabled) {
            Log.e((String)TAG, (String)"device not ready");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 69);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, this.getMediaPlusListener());
    }

    public void showToolbar() {
        if (!this.mToolbarEnabled) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 65);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    private void showTestToolbar() {
        if (this.mToolbar == null) {
            this.mToolbar = new e(this.mContext);
        }
        this.mToolbar.a();
    }

    public void hideToolbar() {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 66);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void showVideoStore() {
        if (!this.mVideoStoreEnabled) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 67);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void takeScreenshot() {
        this.getMediaPlus().takeScreenshot();
    }

    private void checkUpdate() {
        if (!this.mUpdateEnabled) {
            return;
        }
        if (this.mUpdateCounts <= 0) {
            Log.d((String)TAG, (String)"update counts exceed 3 times");
            return;
        }
        --this.mUpdateCounts;
        this.mUpdater = new g(this.mContext, "http://update.lieyou.com/", this.mUpdateSilent, this.getGameId());
        this.mUpdater.a(new d(this));
    }

    private void registerMediaPlusResultListenerForAddon() {
        Log.d((String)TAG, (String)"registerMediaPlusResultListenerForAddon");
        if (!this.mIsEnabled) {
            Log.e((String)TAG, (String)"device not ready");
            return;
        }
        if (null == this.mResultListenerForAddon) {
            this.mResultListenerForAddon = new net.appplus.sdk.shareplus.a();
            c.a().a(this.mResultListenerForAddon);
        }
    }

    private void registerMediaPlusResultListenerForSDK() {
        Log.d((String)TAG, (String)"registerMediaPlusResultListenerForSDK");
        if (!this.mIsEnabled) {
            Log.e((String)TAG, (String)"device not ready");
            return;
        }
        if (null == this.mResultListenerForSDK) {
            this.mResultListenerForSDK = new b();
            c.a().a(this.mResultListenerForSDK);
        }
    }

    private void deletePerfTestFile() {
        String string = this.getTempDirectory();
        File file = new File(string + "/perf.mp4");
        if (file.exists()) {
            file.delete();
        }
    }

    public static void postEventFromNative(int n2, int n3, int n4, Object object) {
        Log.d((String)TAG, (String)("notify from native: " + n2 + ", " + n3 + ", " + n4));
        if (n2 == 97 || n2 == 98 || n2 == 99 || n2 == 100 || n2 == 101 || n2 == 113 || n2 == 114) {
            c.a().a(n2, n3, n4, object);
        } else {
            a a2 = SharePlus.getInstance().mEventHandler;
            if (a2 != null) {
                Message message = a2.obtainMessage(n2, n3, n4, object);
                a2.sendMessage(message);
            }
        }
    }

    public static boolean getBoolean(int n2) {
        switch (n2) {
            case 128: {
                return SharePlus.getInstance().isDeviceSupported();
            }
        }
        return false;
    }

    private void notifyAddonToolbarEanbled() {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 85);
        bundle.putBoolean("toolbar-enabled", this.mToolbarEnabled);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void enableToolbar() {
        this.mToolbarEnabled = true;
        this.notifyAddonToolbarEanbled();
    }

    public void disableToolbar() {
        this.mToolbarEnabled = false;
        this.notifyAddonToolbarEanbled();
    }

    public static void setBoolean(int n2, boolean bl) {
        switch (n2) {
            case 149: {
                SharePlus.getInstance().mUpdateEnabled = bl;
                break;
            }
            case 150: {
                if (bl) {
                    SharePlus.getInstance().enableToolbar();
                    break;
                }
                SharePlus.getInstance().disableToolbar();
                break;
            }
            case 151: {
                SharePlus.getInstance().mVideoStoreEnabled = bl;
                break;
            }
        }
    }

    public static int getInteger(int n2) {
        switch (n2) {
            case 131: {
                return Build.VERSION.SDK_INT;
            }
            case 152: {
                return instance.getVideoQuality();
            }
        }
        return 0;
    }

    public static void setInteger(int n2, int n3) {
        switch (n2) {
            case 152: {
                instance.setVideoQuality(n3);
            }
        }
    }

    public static String getString(int n2) {
        switch (n2) {
            case 130: {
                SharePlus.instance.mVideoPath = SharePlus.getInstance().getFilePath("mp4");
                return SharePlus.instance.mVideoPath;
            }
            case 133: {
                return SharePlus.getInstance().getFilePath("raw");
            }
            case 121: {
                return SharePlus.getInstance().getPackageName();
            }
            case 134: {
                return SharePlus.getInstance().getTempDirectory();
            }
            case 135: {
                SharePlus.instance.mPicturePath = SharePlus.getInstance().getPicturePath("jpg");
                return SharePlus.instance.mPicturePath;
            }
            case 136: {
                return SharePlus.instance.mVideoPath;
            }
            case 137: {
                return SharePlus.instance.mPicturePath;
            }
        }
        return "";
    }

    public boolean isDeviceSupported() {
        if (this.mDebugEnabled) {
            return true;
        }
        boolean bl = false;
        appplus.sharep.i.a a2 = SharePlus.getInstance().getDevice();
        if (a2 != null) {
            bl = a2.a();
        }
        return bl;
    }

    private String getDirectory(String string) {
        if (instance == null) {
            return "";
        }
        if (SharePlus.instance.mContext == null) {
            return "";
        }
        return SDcardUtils.getRealDirPath(SharePlus.instance.mContext, string);
    }

    public String getTempDirectory() {
        if (instance == null) {
            return "";
        }
        if (SharePlus.instance.mContext == null) {
            return "";
        }
        String string = SharePlus.getInstance().getPackageName();
        String string2 = this.getDirectory("shareplus/" + string + "/temp");
        string2 = string2 == null ? "" : string2;
        return string2;
    }

    public String getFilePath(String string) {
        if (instance == null) {
            return "";
        }
        if (SharePlus.instance.mContext == null) {
            return "";
        }
        String string2 = SharePlus.getInstance().getPackageName();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string4 = this.getDirectory("shareplus/" + string2 + "/video");
        string5 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        string3 = string4 + File.separator + "VID_" + string5 + "." + string;
        return string3;
    }

    public String getPicturePath(String string) {
        if (instance == null) {
            return "";
        }
        if (SharePlus.instance.mContext == null) {
            return "";
        }
        String string2 = SharePlus.getInstance().getPackageName();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string4 = this.getDirectory("shareplus/" + string2 + "/picture");
        string5 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        string3 = string4 + File.separator + "PIC_" + string5 + "." + string;
        return string3;
    }

    private String getPackageName() {
        if (instance == null) {
            return null;
        }
        if (SharePlus.instance.mContext == null) {
            return null;
        }
        return SharePlus.instance.mContext.getPackageName();
    }

    public void setOnStartListener(RecNow.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    public RecNow.OnStartListener getOnStartListener() {
        return this.mOnStartListener;
    }

    public void setOnStopListener(RecNow.OnStopListener onStopListener) {
        this.mOnStopListener = onStopListener;
    }

    public RecNow.OnStopListener getOnStopListener() {
        return this.mOnStopListener;
    }

    public void setOnPauseListener(RecNow.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    public RecNow.OnPauseListener getOnPauseListener() {
        return this.mOnPauseListener;
    }

    public void setOnResumeListener(RecNow.OnResumeListener onResumeListener) {
        this.mOnResumeListener = onResumeListener;
    }

    public RecNow.OnResumeListener getOnResumeListener() {
        return this.mOnResumeListener;
    }

    public void setOnErrorListener(RecNow.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public RecNow.OnErrorListener getOnErrorListener() {
        return this.mOnErrorListener;
    }

    public void setOnScreenshotListener(RecNow.OnScreenshotListener onScreenshotListener) {
        this.mOnScreenshotListener = onScreenshotListener;
    }

    public RecNow.OnScreenshotListener getOnScreenshotListener() {
        return this.mOnScreenshotListener;
    }

    public RecNow.OnInitListener getOnInitListener() {
        return this.mOnInitListener;
    }

    public void setOnInitListener(RecNow.OnInitListener onInitListener) {
        this.mOnInitListener = onInitListener;
    }

    private String checkVideoPath(String string) {
        String string2 = "";
        string2 = string == null || string.equals("") ? this.mVideoPath : string;
        return string2;
    }

    public void deleteVideo(String string) {
        String string2 = this.checkVideoPath(string);
        if (string2 == "") {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 71);
        bundle.putString("path", string2);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void playback(String string) {
        String string2 = this.checkVideoPath(string);
        if (string2 == "") {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 80);
        bundle.putString("path", string2);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void fastShare(String string) {
        String string2 = this.checkVideoPath(string);
        if (string2 == "") {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 81);
        bundle.putString("path", string2);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void showPlayerClub() {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 82);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void postMessageToAddon(Message message) {
        Log.d((String)TAG, (String)("post messsage to addon what: " + message.what + ", arg1: " + message.arg1 + ", arg2: " + message.arg2 + ", ext: " + message.obj));
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 83);
        bundle.putInt("what", message.what);
        bundle.putInt("arg1", message.arg1);
        bundle.putInt("arg2", message.arg2);
        if (message.arg1 == 96) {
            bundle.putString("ext", net.appplus.sdk.shareplus.util.a.a((String)message.obj, SharePlus.instance.mVideoPath));
        } else {
            bundle.putString("ext", (String)message.obj);
        }
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public void showWelfareCenter() {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 84);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public int getGameId() {
        return this.mGameId;
    }

    public void setUploadInfo(String string) {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 83);
        bundle.putInt("what", 83);
        bundle.putInt("arg1", 96);
        bundle.putInt("arg2", 0);
        bundle.putString("ext", net.appplus.sdk.shareplus.util.a.a(string, SharePlus.instance.mVideoPath));
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    public Point getScreenSize() {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        display.getSize(point);
        Log.d((String)TAG, (String)("screen size: " + point.x + "x" + point.y));
        return point;
    }

    public void setOnUploadCompletedListener(RecNow.OnUploadCompletedListener onUploadCompletedListener) {
        this.mOnUploadCompletedListener = onUploadCompletedListener;
    }

    public void onUploadCompleted(Bundle bundle) {
        Log.d((String)TAG, (String)("onUploadCompleted:" + bundle.toString()));
        if (null != this.mOnUploadCompletedListener) {
            this.mOnUploadCompletedListener.onUploadCompleted(bundle);
        }
    }

    public void fastUpload(String string) {
        Bundle bundle = new Bundle();
        bundle.putInt("__function_code__", 83);
        bundle.putInt("what", 83);
        bundle.putInt("arg1", 97);
        bundle.putInt("arg2", 0);
        bundle.putString("ext", net.appplus.sdk.shareplus.util.a.a(string, SharePlus.instance.mVideoPath));
        Intent intent = new Intent();
        intent.putExtras(bundle);
        Invoker.invoke(intent, null);
    }

    private static void _nativeInit() {
        if (Build.CPU_ABI.equals("armeabi-v7a")) {
            SharePlus.nativeInit();
        }
    }

    private static void _nativeRelease() {
        if (Build.CPU_ABI.equals("armeabi-v7a")) {
            SharePlus.nativeRelease();
        }
    }

    private static void _nativeOnPause() {
        if (Build.CPU_ABI.equals("armeabi-v7a")) {
            SharePlus.nativeOnPause();
        }
    }

    private static void _nativeOnResume() {
        if (Build.CPU_ABI.equals("armeabi-v7a")) {
            SharePlus.nativeOnResume();
        } else {
            SharePlus.getInstance().showToolbar();
        }
    }

    private static void _nativeOnInit(int n2) {
        if (Build.CPU_ABI.equals("armeabi-v7a")) {
            SharePlus.nativeOnInit(n2);
        }
    }

    private static native void nativeInit();

    private static native void nativeRelease();

    private static native void nativeOnPause();

    private static native void nativeOnResume();

    private static native void nativeOnInit(int var0);

    private class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 65: {
                    SharePlus.getInstance().showToolbar();
                    break;
                }
                case 67: {
                    SharePlus.getInstance().showVideoStore();
                    break;
                }
                case 512: {
                    SharePlus.getInstance().showTestToolbar();
                    break;
                }
                case 66: {
                    SharePlus.getInstance().hideToolbar();
                    break;
                }
                case 69: {
                    SharePlus.this.registerMediaPlusActionListener();
                    break;
                }
                case 70: {
                    SharePlus.this.checkUpdate();
                    break;
                }
                case 519: {
                    SharePlus.this.registerMediaPlusResultListenerForAddon();
                    break;
                }
                case 520: {
                    SharePlus.this.registerMediaPlusResultListenerForSDK();
                    break;
                }
                case 513: {
                    SharePlus.this.deletePerfTestFile();
                    break;
                }
                case 514: {
                    SharePlus.this.startRecord();
                    break;
                }
                case 515: {
                    SharePlus.this.stopRecord();
                    break;
                }
                case 132: {
                    SharePlus.this.pauseRecord();
                    break;
                }
                case 517: {
                    SharePlus.this.resumeRecord();
                    break;
                }
                case 129: {
                    Log.d((String)TAG, (String)"before nativeInit");
                    SharePlus._nativeInit();
                    Log.d((String)TAG, (String)"after nativeInit");
                    break;
                }
                case 133: {
                    Log.d((String)TAG, (String)"before shareplus reinitialize");
                    Invoker.getInstance().setUp();
                    SharePlus.postEventFromNative(129, 0, 0, null);
                    Log.d((String)TAG, (String)"after shareplus reinitialize");
                    break;
                }
                case 71: {
                    SharePlus.this.deleteVideo((String)message.obj);
                    break;
                }
                case 341: {
                    SharePlus.this.onNativeInitCompleted(message.arg1);
                    break;
                }
                case 80: {
                    SharePlus.this.playback((String)message.obj);
                    break;
                }
                case 81: {
                    SharePlus.this.fastShare((String)message.obj);
                    break;
                }
                case 82: {
                    SharePlus.this.showPlayerClub();
                    break;
                }
                case 83: {
                    SharePlus.this.postMessageToAddon(message);
                    break;
                }
                case 84: {
                    SharePlus.this.showWelfareCenter();
                    break;
                }
                case 86: {
                    SharePlus.this.fetchWhiteList();
                    break;
                }
                case 87: {
                    SharePlus.this.fetchCpuMark();
                    break;
                }
                case 88: {
                    SharePlus.this.fetchLogo();
                    break;
                }
                default: {
                    super.handleMessage(message);
                }
            }
        }
    }
}

