/*
 * Decompiled with CFR 0.152.
 */
package net.appplus.sdk.shareplus;

import android.os.Bundle;
import android.util.Log;
import net.appplus.sdk.listener.ActionListener;
import net.appplus.sdk.shareplus.JMediaPlus;
import net.appplus.sdk.shareplus.SharePlus;

public class MediaPlusActionListener
extends ActionListener {
    private static final String TAG = MediaPlusActionListener.class.getName();
    private JMediaPlus mMediaPlus;

    public MediaPlusActionListener(JMediaPlus jMediaPlus) {
        this.mMediaPlus = jMediaPlus;
    }

    public void onAction(Bundle bundle) {
        int n2 = bundle.getInt("mediaplus_action");
        Log.d((String)TAG, (String)("mediaplus_action = " + n2));
        switch (n2) {
            case 71: {
                SharePlus.postEventFromNative(514, 0, 0, null);
                break;
            }
            case 72: {
                SharePlus.postEventFromNative(515, 0, 0, null);
                break;
            }
            case 73: {
                SharePlus.postEventFromNative(132, 0, 0, null);
                break;
            }
            case 74: {
                SharePlus.postEventFromNative(517, 0, 0, null);
                break;
            }
            case 76: {
                this.onSetVideoQuality(bundle);
                break;
            }
            case 80: {
                this.onTakeScreenshot();
                break;
            }
            case 81: {
                this.onGuessVideoQuality();
                break;
            }
            case 82: {
                this.onUploadCompleted(bundle);
            }
        }
    }

    private void onStartRecord() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.startRecord();
        }
    }

    private void onStopRecord() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.stopRecord();
        }
    }

    private void onPauseRecord() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.pauseRecord();
        }
    }

    private void onResumeRecord() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.resumeRecord();
        }
    }

    private void onSetVideoQuality(Bundle bundle) {
        int n2 = bundle.getInt("video-quality", 0);
        SharePlus.getInstance().setVideoQuality(n2);
    }

    private void onTakeScreenshot() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.takeScreenshot();
        }
    }

    private void onGuessVideoQuality() {
        if (this.mMediaPlus != null) {
            this.mMediaPlus.guessVideoQuality();
        }
    }

    private void onUploadCompleted(Bundle bundle) {
        SharePlus.getInstance().onUploadCompleted(bundle);
    }
}

