/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.util;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.SparseArray;
import appplus.sharep.org.acra.ACRA;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class ReportUtils {
    public static long getAvailableInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l3 * l2;
    }

    public static long getTotalInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l3 * l2;
    }

    public static String getDeviceId(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getDeviceId();
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve DeviceId for : " + context.getPackageName()), (Throwable)runtimeException);
            return null;
        }
    }

    public static String getApplicationFilePath(Context context) {
        File file = context.getFilesDir();
        if (file != null) {
            return file.getAbsolutePath();
        }
        Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve ApplicationFilePath for : " + context.getPackageName()));
        return "Couldn't retrieve ApplicationFilePath";
    }

    public static String sparseArrayToString(SparseArray<?> sparseArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sparseArray == null) {
            return "null";
        }
        stringBuilder.append('{');
        int n2 = 0;
        while (n2 < sparseArray.size()) {
            stringBuilder.append(sparseArray.keyAt(n2));
            stringBuilder.append(" => ");
            if (sparseArray.valueAt(n2) == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(sparseArray.valueAt(n2).toString());
            }
            if (n2 < sparseArray.size() - 1) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static String getLocalIpAddress() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (!bl) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(inetAddress.getHostAddress().toString());
                    bl = false;
                }
            }
        }
        catch (SocketException socketException) {
            ACRA.log.w(ACRA.LOG_TAG, socketException.toString());
        }
        return stringBuilder.toString();
    }
}

