/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;

public final class PackageManagerWrapper {
    private final Context context;

    public PackageManagerWrapper(Context context) {
        this.context = context;
    }

    public boolean hasPermission(String string) {
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        try {
            return packageManager.checkPermission(string, this.context.getPackageName()) == 0;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public PackageInfo getPackageInfo() {
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        try {
            return packageManager.getPackageInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.v((String)ACRA.LOG_TAG, (String)("Failed to find PackageInfo for current App : " + this.context.getPackageName()));
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

