/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.util;

import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONReportBuilder {
    public static JSONObject buildJSONReport(CrashReportData crashReportData) throws JSONReportException {
        JSONObject jSONObject = new JSONObject();
        for (ReportField reportField : crashReportData.keySet()) {
            try {
                if (reportField.containsKeyValuePairs()) {
                    JSONObject jSONObject2 = new JSONObject();
                    String string = crashReportData.getProperty(reportField);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(string), 1024);
                    String string2 = null;
                    try {
                        while ((string2 = bufferedReader.readLine()) != null) {
                            JSONReportBuilder.addJSONFromProperty(jSONObject2, string2);
                        }
                    }
                    catch (IOException iOException) {
                        ACRA.log.e(ACRA.LOG_TAG, "Error while converting " + reportField.name() + " to JSON.", iOException);
                    }
                    jSONObject.accumulate(reportField.name(), (Object)jSONObject2);
                    continue;
                }
                jSONObject.accumulate(reportField.name(), JSONReportBuilder.guessType(crashReportData.getProperty(reportField)));
            }
            catch (JSONException jSONException) {
                throw new JSONReportException("Could not create JSON object for key " + (Object)((Object)reportField), jSONException);
            }
        }
        return jSONObject;
    }

    private static void addJSONFromProperty(JSONObject jSONObject, String string) throws JSONException {
        int n2 = string.indexOf(61);
        if (n2 > 0) {
            String[] stringArray;
            JSONObject jSONObject2 = jSONObject;
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1).trim();
            Object object = JSONReportBuilder.guessType(string3);
            if (object instanceof String) {
                object = ((String)object).replaceAll("\\\\n", "\n");
            }
            if ((stringArray = string2.split("\\.")).length > 1) {
                JSONReportBuilder.addJSONSubTree(jSONObject2, stringArray, object);
            } else {
                jSONObject2.accumulate(string2, object);
            }
        } else {
            jSONObject.put(string.trim(), true);
        }
    }

    private static Object guessType(String string) {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.matches("(?:^|\\s)([1-9](?:\\d*|(?:\\d{0,2})(?:,\\d{3})*)(?:\\.\\d*[1-9])?|0?\\.\\d*[1-9]|0)(?:\\s|$)")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            try {
                Number number = numberFormat.parse(string);
                return number;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return string;
    }

    private static void addJSONSubTree(JSONObject jSONObject, String[] stringArray, Object object) throws JSONException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (n2 < stringArray.length - 1) {
                JSONObject jSONObject2 = null;
                if (jSONObject.isNull(string)) {
                    jSONObject2 = new JSONObject();
                    jSONObject.accumulate(string, (Object)jSONObject2);
                } else {
                    jSONObject2 = jSONObject.getJSONObject(string);
                }
                jSONObject = jSONObject2;
            } else {
                jSONObject.accumulate(string, object);
            }
            ++n2;
        }
    }

    public static class JSONReportException
    extends Exception {
        private static final long serialVersionUID = -694684023635442219L;

        public JSONReportException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

