/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.util;

import android.content.Context;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;

public class Installation {
    private static String sID;
    private static final String INSTALLATION = "ACRA-INSTALLATION";

    public static synchronized String id(Context context) {
        if (sID == null) {
            File file = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!file.exists()) {
                    Installation.writeInstallationFile(file);
                }
                sID = Installation.readInstallationFile(file);
            }
            catch (IOException iOException) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)iOException);
                return "Couldn't retrieve InstallationId";
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)runtimeException);
                return "Couldn't retrieve InstallationId";
            }
        }
        return sID;
    }

    private static String readInstallationFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        try {
            randomAccessFile.readFully(byArray);
        }
        finally {
            randomAccessFile.close();
        }
        return new String(byArray);
    }

    private static void writeInstallationFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            String string = UUID.randomUUID().toString();
            fileOutputStream.write(string.getBytes());
        }
        finally {
            fileOutputStream.close();
        }
    }
}

