/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.util;

import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.sender.HttpSender;
import appplus.sharep.org.acra.util.FakeSocketFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class HttpRequest {
    private String login;
    private String password;
    private int connectionTimeOut = 3000;
    private int socketTimeOut = 3000;
    private int maxNrRetries = 3;
    private Map<String, String> headers;

    public void setLogin(String string) {
        this.login = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setConnectionTimeOut(int n2) {
        this.connectionTimeOut = n2;
    }

    public void setSocketTimeOut(int n2) {
        this.socketTimeOut = n2;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    public void setMaxNrRetries(int n2) {
        this.maxNrRetries = n2;
    }

    public void send(URL uRL, HttpSender.Method method, String string, HttpSender.Type type) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = this.getHttpRequest(uRL, method, string, type);
        ACRA.log.d(ACRA.LOG_TAG, "Sending request to " + uRL);
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpEntityEnclosingRequestBase, (HttpContext)new BasicHttpContext());
            if (httpResponse != null) {
                String string2;
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && !(string2 = Integer.toString(httpResponse.getStatusLine().getStatusCode())).equals("409") && !string2.equals("403") && (string2.startsWith("4") || string2.startsWith("5"))) {
                    throw new IOException("Host returned error code " + string2);
                }
                string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            }
        }
        finally {
            if (httpResponse != null) {
                httpResponse.getEntity().consumeContent();
            }
        }
    }

    private HttpClient getHttpClient() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)this.connectionTimeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)this.socketTimeOut);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80));
        if (ACRA.getConfig().disableSSLCertValidation()) {
            schemeRegistry.register(new Scheme("https", (SocketFactory)new FakeSocketFactory(), 443));
        } else {
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        }
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
        SocketTimeOutRetryHandler socketTimeOutRetryHandler = new SocketTimeOutRetryHandler((HttpParams)basicHttpParams, this.maxNrRetries);
        defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)socketTimeOutRetryHandler);
        return defaultHttpClient;
    }

    private UsernamePasswordCredentials getCredentials() {
        if (this.login != null || this.password != null) {
            return new UsernamePasswordCredentials(this.login, this.password);
        }
        return null;
    }

    private HttpEntityEnclosingRequestBase getHttpRequest(URL uRL, HttpSender.Method method, String string, HttpSender.Type type) throws UnsupportedEncodingException, UnsupportedOperationException {
        HttpPost httpPost;
        switch (method) {
            case POST: {
                httpPost = new HttpPost(uRL.toString());
                break;
            }
            case PUT: {
                httpPost = new HttpPut(uRL.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown method: " + method.name());
            }
        }
        UsernamePasswordCredentials usernamePasswordCredentials = this.getCredentials();
        if (usernamePasswordCredentials != null) {
            httpPost.addHeader(BasicScheme.authenticate((Credentials)usernamePasswordCredentials, (String)"UTF-8", (boolean)false));
        }
        httpPost.setHeader("User-Agent", "Android");
        httpPost.setHeader("Accept", "text/html,application/xml,application/json,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        httpPost.setHeader("Content-Type", type.getContentType());
        if (this.headers != null) {
            for (String string2 : this.headers.keySet()) {
                String string3 = this.headers.get(string2);
                httpPost.setHeader(string2, string3);
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(string, "UTF-8"));
        return httpPost;
    }

    public static String getParamsAsFormString(Map<?, ?> map) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : map.keySet()) {
            Object obj2;
            if (stringBuilder.length() != 0) {
                stringBuilder.append('&');
            }
            String string = (obj2 = map.get(obj)) == null ? "" : obj2;
            stringBuilder.append(URLEncoder.encode(obj.toString(), "UTF-8"));
            stringBuilder.append('=');
            stringBuilder.append(URLEncoder.encode(string.toString(), "UTF-8"));
        }
        return stringBuilder.toString();
    }

    private static class SocketTimeOutRetryHandler
    implements HttpRequestRetryHandler {
        private final HttpParams httpParams;
        private final int maxNrRetries;

        private SocketTimeOutRetryHandler(HttpParams httpParams, int n2) {
            this.httpParams = httpParams;
            this.maxNrRetries = n2;
        }

        public boolean retryRequest(IOException iOException, int n2, HttpContext httpContext) {
            if (iOException instanceof SocketTimeoutException) {
                if (n2 <= this.maxNrRetries) {
                    if (this.httpParams != null) {
                        int n3 = HttpConnectionParams.getSoTimeout((HttpParams)this.httpParams) * 2;
                        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)n3);
                        ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - increasing time out to " + n3 + " millis and trying again");
                    } else {
                        ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - no HttpParams, cannot increase time out. Trying again with current settings");
                    }
                    return true;
                }
                ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut but exceeded max number of retries : " + this.maxNrRetries);
            }
            return false;
        }
    }
}

