/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.sender;

import android.net.Uri;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.ACRAConfiguration;
import appplus.sharep.org.acra.ACRAConstants;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.sender.ReportSender;
import appplus.sharep.org.acra.sender.ReportSenderException;
import appplus.sharep.org.acra.util.HttpRequest;
import appplus.sharep.org.acra.util.JSONReportBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpSender
implements ReportSender {
    private final Uri mFormUri;
    private final Map<ReportField, String> mMapping;
    private final Method mMethod;
    private final Type mType;
    private String mUsername;
    private String mPassword;

    public HttpSender(Method method, Type type, Map<ReportField, String> map) {
        this.mMethod = method;
        this.mFormUri = null;
        this.mMapping = map;
        this.mType = type;
        this.mUsername = null;
        this.mPassword = null;
    }

    public HttpSender(Method method, Type type, String string, Map<ReportField, String> map) {
        this.mMethod = method;
        this.mFormUri = Uri.parse((String)string);
        this.mMapping = map;
        this.mType = type;
        this.mUsername = null;
        this.mPassword = null;
    }

    public void setBasicAuth(String string, String string2) {
        this.mUsername = string;
        this.mPassword = string2;
    }

    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        try {
            String string;
            URL uRL = this.mFormUri == null ? new URL(ACRA.getConfig().formUri()) : new URL(this.mFormUri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + uRL.toString()));
            String string2 = this.mUsername != null ? this.mUsername : (string = ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthLogin()) ? null : ACRA.getConfig().formUriBasicAuthLogin());
            String string3 = this.mPassword != null ? this.mPassword : (ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthPassword()) ? null : ACRA.getConfig().formUriBasicAuthPassword());
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            httpRequest.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            httpRequest.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            httpRequest.setLogin(string);
            httpRequest.setPassword(string3);
            httpRequest.setHeaders(ACRA.getConfig().getHttpHeaders());
            String string4 = "";
            switch (this.mType) {
                case JSON: {
                    string4 = crashReportData.toJSON().toString();
                    break;
                }
                default: {
                    Map<String, String> map = this.remap(crashReportData);
                    string4 = HttpRequest.getParamsAsFormString(map);
                }
            }
            switch (this.mMethod) {
                case POST: {
                    break;
                }
                case PUT: {
                    uRL = new URL(String.valueOf(uRL.toString()) + '/' + crashReportData.getProperty(ReportField.REPORT_ID));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown method: " + this.mMethod.name());
                }
            }
            httpRequest.send(uRL, this.mMethod, string4, this.mType);
        }
        catch (IOException iOException) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), iOException);
        }
        catch (JSONReportBuilder.JSONReportException jSONReportException) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), jSONReportException);
        }
    }

    private Map<String, String> remap(Map<ReportField, String> map) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        ReportField[] reportFieldArray2 = reportFieldArray;
        int n2 = reportFieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReportField reportField = reportFieldArray2[n3];
            if (this.mMapping == null || this.mMapping.get((Object)reportField) == null) {
                hashMap.put(reportField.toString(), map.get((Object)reportField));
            } else {
                hashMap.put(this.mMapping.get((Object)reportField), map.get((Object)reportField));
            }
            ++n3;
        }
        return hashMap;
    }

    public static enum Method {
        POST,
        PUT;

    }

    public static enum Type {
        FORM{

            @Override
            public String getContentType() {
                return "application/x-www-form-urlencoded";
            }
        }
        ,
        JSON{

            @Override
            public String getContentType() {
                return "application/json";
            }
        };


        public abstract String getContentType();
    }
}

