/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.sender;

import android.net.Uri;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.ACRAConstants;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.sender.HttpSender;
import appplus.sharep.org.acra.sender.ReportSender;
import appplus.sharep.org.acra.sender.ReportSenderException;
import appplus.sharep.org.acra.util.HttpRequest;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GoogleFormSender
implements ReportSender {
    private final Uri mFormUri;

    public GoogleFormSender() {
        this.mFormUri = null;
    }

    public GoogleFormSender(String string) {
        this.mFormUri = Uri.parse((String)String.format(ACRA.getConfig().googleFormUrlFormat(), string));
    }

    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        Uri uri = this.mFormUri == null ? Uri.parse((String)String.format(ACRA.getConfig().googleFormUrlFormat(), ACRA.getConfig().formKey())) : this.mFormUri;
        Map<String, String> map = this.remap(crashReportData);
        map.put("pageNumber", "0");
        map.put("backupCache", "");
        map.put("submit", "Envoyer");
        try {
            URL uRL = new URL(uri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Sending report " + (String)crashReportData.get((Object)ReportField.REPORT_ID)));
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + uRL));
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            httpRequest.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            httpRequest.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            httpRequest.send(uRL, HttpSender.Method.POST, HttpRequest.getParamsAsFormString(map), HttpSender.Type.FORM);
        }
        catch (IOException iOException) {
            throw new ReportSenderException("Error while sending report to Google Form.", iOException);
        }
    }

    private Map<String, String> remap(Map<ReportField, String> map) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        int n2 = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportField[] reportFieldArray2 = reportFieldArray;
        int n3 = reportFieldArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ReportField reportField = reportFieldArray2[n4];
            switch (reportField) {
                case APP_VERSION_NAME: {
                    hashMap.put("entry." + n2 + ".single", "'" + map.get((Object)reportField));
                    break;
                }
                case ANDROID_VERSION: {
                    hashMap.put("entry." + n2 + ".single", "'" + map.get((Object)reportField));
                    break;
                }
                default: {
                    hashMap.put("entry." + n2 + ".single", map.get((Object)reportField));
                }
            }
            ++n2;
            ++n4;
        }
        return hashMap;
    }
}

