/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.sender;

import android.content.Context;
import android.content.Intent;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.ACRAConstants;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.sender.ReportSender;
import appplus.sharep.org.acra.sender.ReportSenderException;

public class EmailIntentSender
implements ReportSender {
    private final Context mContext;

    public EmailIntentSender(Context context) {
        this.mContext = context;
    }

    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        String string = String.valueOf(this.mContext.getPackageName()) + " Crash Report";
        String string2 = this.buildBody(crashReportData);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.addFlags(0x10000000);
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", string);
        intent.putExtra("android.intent.extra.TEXT", string2);
        intent.putExtra("android.intent.extra.EMAIL", new String[]{ACRA.getConfig().mailTo()});
        this.mContext.startActivity(intent);
    }

    private String buildBody(CrashReportData crashReportData) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_MAIL_REPORT_FIELDS;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ReportField[] reportFieldArray2 = reportFieldArray;
        int n2 = reportFieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReportField reportField = reportFieldArray2[n3];
            stringBuilder.append(reportField.toString()).append("=");
            stringBuilder.append((String)crashReportData.get((Object)reportField));
            stringBuilder.append('\n');
            ++n3;
        }
        return stringBuilder.toString();
    }
}

