/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat;

import android.annotation.TargetApi;
import android.app.Application;
import android.os.Build;
import appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat.ActivityLifecycleCallbacksCompat;
import appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat.ActivityLifecycleCallbacksWrapper;
import appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat.MainLifecycleDispatcher;

public class ApplicationHelper {
    public static final boolean PRE_ICS = Build.VERSION.SDK_INT < 14;

    public static void registerActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        if (PRE_ICS) {
            ApplicationHelper.preIcsRegisterActivityLifecycleCallbacks(activityLifecycleCallbacksCompat);
        } else {
            ApplicationHelper.postIcsRegisterActivityLifecycleCallbacks(application, activityLifecycleCallbacksCompat);
        }
    }

    private static void preIcsRegisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        MainLifecycleDispatcher.get().registerActivityLifecycleCallbacks(activityLifecycleCallbacksCompat);
    }

    @TargetApi(value=14)
    private static void postIcsRegisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(activityLifecycleCallbacksCompat));
    }

    public void unregisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        if (PRE_ICS) {
            ApplicationHelper.preIcsUnregisterActivityLifecycleCallbacks(activityLifecycleCallbacksCompat);
        } else {
            ApplicationHelper.postIcsUnregisterActivityLifecycleCallbacks(application, activityLifecycleCallbacksCompat);
        }
    }

    private static void preIcsUnregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        MainLifecycleDispatcher.get().unregisterActivityLifecycleCallbacks(activityLifecycleCallbacksCompat);
    }

    @TargetApi(value=14)
    private static void postIcsUnregisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat activityLifecycleCallbacksCompat) {
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(activityLifecycleCallbacksCompat));
    }
}

