/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.collector.Compatibility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class SettingsCollector {
    SettingsCollector() {
    }

    public static String collectSystemSettings(Context context) {
        Field[] fieldArray;
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray2 = fieldArray = Settings.System.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray2[n3];
            if (!field.isAnnotationPresent(Deprecated.class) && field.getType() == String.class) {
                try {
                    String string = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)((String)field.get(null)));
                    if (string != null) {
                        stringBuilder.append(field.getName()).append("=").append((Object)string).append("\n");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
                }
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String collectSecureSettings(Context context) {
        Field[] fieldArray;
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray2 = fieldArray = Settings.Secure.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray2[n3];
            if (!field.isAnnotationPresent(Deprecated.class) && field.getType() == String.class && SettingsCollector.isAuthorized(field)) {
                try {
                    String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)((String)field.get(null)));
                    if (string != null) {
                        stringBuilder.append(field.getName()).append("=").append((Object)string).append("\n");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
                }
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String collectGlobalSettings(Context context) {
        if (Compatibility.getAPILevel() < 17) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Class<?> clazz = Class.forName("android.provider.Settings$Global");
            Field[] fieldArray = clazz.getFields();
            Method method = clazz.getMethod("getString", ContentResolver.class, String.class);
            Field[] fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                Field field = fieldArray2[n3];
                if (!field.isAnnotationPresent(Deprecated.class) && field.getType() == String.class && SettingsCollector.isAuthorized(field) && (object = method.invoke(null, context.getContentResolver(), (String)field.get(null))) != null) {
                    stringBuilder.append(field.getName()).append("=").append(object).append("\n");
                }
                ++n3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)classNotFoundException);
        }
        catch (SecurityException securityException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)invocationTargetException);
        }
        return stringBuilder.toString();
    }

    private static boolean isAuthorized(Field field) {
        if (field == null || field.getName().startsWith("WIFI_AP")) {
            return false;
        }
        String[] stringArray = ACRA.getConfig().excludeMatchingSettingsKeys();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (field.getName().matches(string)) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

