/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.util.SparseArray;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MediaCodecListCollector {
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
    private static final String[] AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
    private static final String[] H263_TYPES = new String[]{"h263", "H263"};
    private static final String[] AAC_TYPES = new String[]{"aac", "AAC"};
    private static Class<?> mediaCodecListClass = null;
    private static Method getCodecInfoAtMethod = null;
    private static Class<?> mediaCodecInfoClass = null;
    private static Method getNameMethod = null;
    private static Method isEncoderMethod = null;
    private static Method getSupportedTypesMethod = null;
    private static Method getCapabilitiesForTypeMethod = null;
    private static Class<?> codecCapabilitiesClass = null;
    private static Field colorFormatsField = null;
    private static Field profileLevelsField = null;
    private static Field profileField = null;
    private static Field levelField = null;
    private static SparseArray<String> mColorFormatValues = new SparseArray();
    private static SparseArray<String> mAVCLevelValues = new SparseArray();
    private static SparseArray<String> mAVCProfileValues = new SparseArray();
    private static SparseArray<String> mH263LevelValues = new SparseArray();
    private static SparseArray<String> mH263ProfileValues = new SparseArray();
    private static SparseArray<String> mMPEG4LevelValues = new SparseArray();
    private static SparseArray<String> mMPEG4ProfileValues = new SparseArray();
    private static SparseArray<String> mAACProfileValues = new SparseArray();

    static {
        try {
            AnnotatedElement annotatedElement;
            mediaCodecListClass = Class.forName("android.media.MediaCodecList");
            getCodecInfoAtMethod = mediaCodecListClass.getMethod("getCodecInfoAt", Integer.TYPE);
            mediaCodecInfoClass = Class.forName("android.media.MediaCodecInfo");
            getNameMethod = mediaCodecInfoClass.getMethod("getName", new Class[0]);
            isEncoderMethod = mediaCodecInfoClass.getMethod("isEncoder", new Class[0]);
            getSupportedTypesMethod = mediaCodecInfoClass.getMethod("getSupportedTypes", new Class[0]);
            getCapabilitiesForTypeMethod = mediaCodecInfoClass.getMethod("getCapabilitiesForType", String.class);
            codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            colorFormatsField = codecCapabilitiesClass.getField("colorFormats");
            profileLevelsField = codecCapabilitiesClass.getField("profileLevels");
            Field[] fieldArray = codecCapabilitiesClass.getFields();
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                annotatedElement = fieldArray[n3];
                if (Modifier.isStatic(((Field)annotatedElement).getModifiers()) && Modifier.isFinal(((Field)annotatedElement).getModifiers()) && ((Field)annotatedElement).getName().startsWith(COLOR_FORMAT_PREFIX)) {
                    mColorFormatValues.put(((Field)annotatedElement).getInt(null), (Object)((Field)annotatedElement).getName());
                }
                ++n3;
            }
            annotatedElement = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            Field[] fieldArray2 = ((Class)annotatedElement).getFields();
            int n4 = fieldArray2.length;
            n2 = 0;
            while (n2 < n4) {
                Field field = fieldArray2[n2];
                if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                    if (field.getName().startsWith("AVCLevel")) {
                        mAVCLevelValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("AVCProfile")) {
                        mAVCProfileValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("H263Level")) {
                        mH263LevelValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("H263Profile")) {
                        mH263ProfileValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("MPEG4Level")) {
                        mMPEG4LevelValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("MPEG4Profile")) {
                        mMPEG4ProfileValues.put(field.getInt(null), (Object)field.getName());
                    } else if (field.getName().startsWith("AAC")) {
                        mAACProfileValues.put(field.getInt(null), (Object)field.getName());
                    }
                }
                ++n2;
            }
            profileField = ((Class)annotatedElement).getField("profile");
            levelField = ((Class)annotatedElement).getField("level");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static String collecMediaCodecList() {
        StringBuilder stringBuilder = new StringBuilder();
        if (mediaCodecListClass != null && mediaCodecInfoClass != null) {
            try {
                int n2 = (Integer)mediaCodecListClass.getMethod("getCodecCount", new Class[0]).invoke(null, new Object[0]);
                Object object = null;
                int n3 = 0;
                while (n3 < n2) {
                    stringBuilder.append("\n");
                    object = getCodecInfoAtMethod.invoke(null, n3);
                    stringBuilder.append(n3).append(": ").append(getNameMethod.invoke(object, new Object[0])).append("\n");
                    stringBuilder.append("isEncoder: ").append(isEncoderMethod.invoke(object, new Object[0])).append("\n");
                    Object[] objectArray = (String[])getSupportedTypesMethod.invoke(object, new Object[0]);
                    stringBuilder.append("Supported types: ").append(Arrays.toString(objectArray)).append("\n");
                    Object[] objectArray2 = objectArray;
                    int n4 = objectArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object object2 = objectArray2[n5];
                        stringBuilder.append(MediaCodecListCollector.collectCapabilitiesForType(object, (String)object2));
                        ++n5;
                    }
                    stringBuilder.append("\n");
                    ++n3;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    private static String collectCapabilitiesForType(Object object, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = getCapabilitiesForTypeMethod.invoke(object, string);
        int[] nArray = (int[])colorFormatsField.get(object2);
        if (nArray.length > 0) {
            stringBuilder.append(string).append(" color formats:");
            int n2 = 0;
            while (n2 < nArray.length) {
                stringBuilder.append((String)mColorFormatValues.get(nArray[n2]));
                if (n2 < nArray.length - 1) {
                    stringBuilder.append(',');
                }
                ++n2;
            }
            stringBuilder.append("\n");
        }
        if ((objectArray = (Object[])profileLevelsField.get(object2)).length > 0) {
            stringBuilder.append(string).append(" profile levels:");
            int n3 = 0;
            while (n3 < objectArray.length) {
                CodecType codecType = MediaCodecListCollector.identifyCodecType(object);
                int n4 = profileField.getInt(objectArray[n3]);
                int n5 = levelField.getInt(objectArray[n3]);
                if (codecType == null) {
                    stringBuilder.append(n4).append('-').append(n5);
                }
                switch (codecType) {
                    case AVC: {
                        stringBuilder.append(n4).append((String)mAVCProfileValues.get(n4)).append('-').append((String)mAVCLevelValues.get(n5));
                        break;
                    }
                    case H263: {
                        stringBuilder.append((String)mH263ProfileValues.get(n4)).append('-').append((String)mH263LevelValues.get(n5));
                        break;
                    }
                    case MPEG4: {
                        stringBuilder.append((String)mMPEG4ProfileValues.get(n4)).append('-').append((String)mMPEG4LevelValues.get(n5));
                        break;
                    }
                    case AAC: {
                        stringBuilder.append((String)mAACProfileValues.get(n4));
                        break;
                    }
                }
                if (n3 < objectArray.length - 1) {
                    stringBuilder.append(',');
                }
                ++n3;
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.append("\n").toString();
    }

    private static CodecType identifyCodecType(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String string;
        String string2 = (String)getNameMethod.invoke(object, new Object[0]);
        String[] stringArray = AVC_TYPES;
        int n2 = AVC_TYPES.length;
        int n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            if (string2.contains(string)) {
                return CodecType.AVC;
            }
            ++n3;
        }
        stringArray = H263_TYPES;
        n2 = H263_TYPES.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            if (string2.contains(string)) {
                return CodecType.H263;
            }
            ++n3;
        }
        stringArray = MPEG4_TYPES;
        n2 = MPEG4_TYPES.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            if (string2.contains(string)) {
                return CodecType.MPEG4;
            }
            ++n3;
        }
        stringArray = AAC_TYPES;
        n2 = AAC_TYPES.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            if (string2.contains(string)) {
                return CodecType.AAC;
            }
            ++n3;
        }
        return null;
    }

    private static enum CodecType {
        AVC,
        H263,
        MPEG4,
        AAC;

    }
}

