/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.content.Context;
import android.text.format.Time;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.collector.Compatibility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

final class DropBoxCollector {
    private static final String[] SYSTEM_TAGS = new String[]{"system_app_anr", "system_app_wtf", "system_app_crash", "system_server_anr", "system_server_wtf", "system_server_crash", "BATTERY_DISCHARGE_INFO", "SYSTEM_RECOVERY_LOG", "SYSTEM_BOOT", "SYSTEM_LAST_KMSG", "APANIC_CONSOLE", "APANIC_THREADS", "SYSTEM_RESTART", "SYSTEM_TOMBSTONE", "data_app_strictmode"};
    private static final String NO_RESULT = "N/A";

    DropBoxCollector() {
    }

    public static String read(Context context, String[] stringArray) {
        ArrayList<String> arrayList;
        long l2;
        Time time;
        Method method;
        Object object;
        block19: {
            block18: {
                String string;
                block17: {
                    string = Compatibility.getDropBoxServiceName();
                    if (string != null) break block17;
                    return NO_RESULT;
                }
                object = context.getSystemService(string);
                method = object.getClass().getMethod("getNextEntry", String.class, Long.TYPE);
                if (method != null) break block18;
                return "";
            }
            time = new Time();
            time.setToNow();
            time.minute -= ACRA.getConfig().dropboxCollectionMinutes();
            time.normalize(false);
            l2 = time.toMillis(false);
            arrayList = new ArrayList<String>();
            if (ACRA.getConfig().includeDropBoxSystemTags()) {
                arrayList.addAll(Arrays.asList(SYSTEM_TAGS));
            }
            if (stringArray != null && stringArray.length > 0) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
            if (!arrayList.isEmpty()) break block19;
            return "No tag configured for collection.";
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                stringBuilder.append("Tag: ").append(string).append('\n');
                Object object2 = method.invoke(object, string, l2);
                if (object2 == null) {
                    stringBuilder.append("Nothing.").append('\n');
                    continue;
                }
                Method method2 = object2.getClass().getMethod("getText", Integer.TYPE);
                Method method3 = object2.getClass().getMethod("getTimeMillis", null);
                Method method4 = object2.getClass().getMethod("close", null);
                while (object2 != null) {
                    long l3 = (Long)method3.invoke(object2, null);
                    time.set(l3);
                    stringBuilder.append("@").append(time.format2445()).append('\n');
                    String string2 = (String)method2.invoke(object2, 500);
                    if (string2 != null) {
                        stringBuilder.append("Text: ").append(string2).append('\n');
                    } else {
                        stringBuilder.append("Not Text!").append('\n');
                    }
                    method4.invoke(object2, null);
                    object2 = method.invoke(object, string, l3);
                }
            }
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.i((String)ACRA.LOG_TAG, (String)"DropBoxManager not available.");
        }
        return NO_RESULT;
    }
}

