/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.collector.Compatibility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class DisplayManagerCollector {
    static final SparseArray<String> mFlagsNames = new SparseArray();
    static final SparseArray<String> mDensities = new SparseArray();

    DisplayManagerCollector() {
    }

    public static String collectDisplays(Context context) {
        Object object;
        Display[] displayArray = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (Compatibility.getAPILevel() < 17) {
            object = (WindowManager)context.getSystemService("window");
            displayArray = new Display[]{object.getDefaultDisplay()};
        } else {
            try {
                object = context.getSystemService((String)context.getClass().getField("DISPLAY_SERVICE").get(null));
                Method method = object.getClass().getMethod("getDisplays", new Class[0]);
                displayArray = (Display[])method.invoke(object, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", illegalArgumentException);
            }
            catch (SecurityException securityException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", securityException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", noSuchFieldException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", invocationTargetException);
            }
        }
        Display[] displayArray2 = displayArray;
        int n2 = displayArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = displayArray2[n3];
            stringBuilder.append(DisplayManagerCollector.collectDisplayData((Display)object));
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static Object collectDisplayData(Display display) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DisplayManagerCollector.collectCurrentSizeRange(display));
        stringBuilder.append(DisplayManagerCollector.collectFlags(display));
        stringBuilder.append(display.getDisplayId()).append(".height=").append(display.getHeight()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectMetrics(display, "getMetrics"));
        stringBuilder.append(DisplayManagerCollector.collectName(display));
        stringBuilder.append(display.getDisplayId()).append(".orientation=").append(display.getOrientation()).append('\n');
        stringBuilder.append(display.getDisplayId()).append(".pixelFormat=").append(display.getPixelFormat()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectMetrics(display, "getRealMetrics"));
        stringBuilder.append(DisplayManagerCollector.collectSize(display, "getRealSize"));
        stringBuilder.append(DisplayManagerCollector.collectRectSize(display));
        stringBuilder.append(display.getDisplayId()).append(".refreshRate=").append(display.getRefreshRate()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectRotation(display));
        stringBuilder.append(DisplayManagerCollector.collectSize(display, "getSize"));
        stringBuilder.append(display.getDisplayId()).append(".width=").append(display.getWidth()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectIsValid(display));
        return stringBuilder.toString();
    }

    private static Object collectIsValid(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("isValid", new Class[0]);
            Boolean bl = (Boolean)method.invoke((Object)display, new Object[0]);
            stringBuilder.append(display.getDisplayId()).append(".isValid=").append(bl).append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static Object collectRotation(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getRotation", new Class[0]);
            int n2 = (Integer)method.invoke((Object)display, new Object[0]);
            stringBuilder.append(display.getDisplayId()).append(".rotation=");
            switch (n2) {
                case 0: {
                    stringBuilder.append("ROTATION_0");
                    break;
                }
                case 1: {
                    stringBuilder.append("ROTATION_90");
                    break;
                }
                case 2: {
                    stringBuilder.append("ROTATION_180");
                    break;
                }
                case 3: {
                    stringBuilder.append("ROTATION_270");
                    break;
                }
                default: {
                    stringBuilder.append(n2);
                }
            }
            stringBuilder.append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static Object collectRectSize(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getRectSize", Rect.class);
            Rect rect = new Rect();
            method.invoke((Object)display, rect);
            stringBuilder.append(display.getDisplayId()).append(".rectSize=[").append(rect.top).append(',').append(rect.left).append(',').append(rect.width()).append(',').append(rect.height()).append(']').append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static Object collectSize(Display display, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod(string, Point.class);
            Point point = new Point();
            method.invoke((Object)display, point);
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append("=[").append(point.x).append(',').append(point.y).append(']').append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static String collectCurrentSizeRange(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getCurrentSizeRange", Point.class, Point.class);
            Point point = new Point();
            Point point2 = new Point();
            method.invoke((Object)display, point, point2);
            stringBuilder.append(display.getDisplayId()).append(".currentSizeRange.smallest=[").append(point.x).append(',').append(point.y).append(']').append('\n');
            stringBuilder.append(display.getDisplayId()).append(".currentSizeRange.largest=[").append(point2.x).append(',').append(point2.y).append(']').append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static String collectFlags(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getFlags", new Class[0]);
            int n2 = (Integer)method.invoke((Object)display, new Object[0]);
            Field[] fieldArray = display.getClass().getFields();
            int n3 = fieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Field field = fieldArray[n4];
                if (field.getName().startsWith("FLAG_")) {
                    mFlagsNames.put(field.getInt(null), (Object)field.getName());
                }
                ++n4;
            }
            stringBuilder.append(display.getDisplayId()).append(".flags=").append(DisplayManagerCollector.activeFlags(mFlagsNames, n2)).append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static String collectName(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getName", new Class[0]);
            String string = (String)method.invoke((Object)display, new Object[0]);
            stringBuilder.append(display.getDisplayId()).append(".name=").append(string).append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static Object collectMetrics(Display display, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod(string, new Class[0]);
            DisplayMetrics displayMetrics = (DisplayMetrics)method.invoke((Object)display, new Object[0]);
            Field[] fieldArray = DisplayMetrics.class.getFields();
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Field field = fieldArray[n3];
                if (field.getType().equals(Integer.class) && field.getName().startsWith("DENSITY_") && !field.getName().equals("DENSITY_DEFAULT")) {
                    mDensities.put(field.getInt(null), (Object)field.getName());
                }
                ++n3;
            }
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".density=").append(displayMetrics.density).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".densityDpi=").append(displayMetrics.getClass().getField("densityDpi")).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append("scaledDensity=x").append(displayMetrics.scaledDensity).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".widthPixels=").append(displayMetrics.widthPixels).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".heightPixels=").append(displayMetrics.heightPixels).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".xdpi=").append(displayMetrics.xdpi).append('\n');
            stringBuilder.append(display.getDisplayId()).append('.').append(string).append(".ydpi=").append(displayMetrics.ydpi).append('\n');
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private static String activeFlags(SparseArray<String> sparseArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < sparseArray.size()) {
            int n4 = sparseArray.keyAt(n3);
            int n5 = n2 & n4;
            if (n5 > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append((String)sparseArray.get(n5));
            }
            ++n3;
        }
        return stringBuilder.toString();
    }
}

