/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.collector.Compatibility;
import java.lang.reflect.Method;

final class DeviceFeaturesCollector {
    DeviceFeaturesCollector() {
    }

    public static String getFeatures(Context context) {
        if (Compatibility.getAPILevel() < 5) {
            return "Data available only with API Level >= 5";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object[] objectArray;
            PackageManager packageManager = context.getPackageManager();
            Method method = PackageManager.class.getMethod("getSystemAvailableFeatures", null);
            Object[] objectArray2 = objectArray = (Object[])method.invoke((Object)packageManager, new Object[0]);
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object = objectArray2[n3];
                String string = (String)object.getClass().getField("name").get(object);
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    Method method2 = object.getClass().getMethod("getGlEsVersion", null);
                    String string2 = (String)method2.invoke(object, new Object[0]);
                    stringBuilder.append("glEsVersion = ");
                    stringBuilder.append(string2);
                }
                stringBuilder.append("\n");
                ++n3;
            }
        }
        catch (Throwable throwable) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve DeviceFeatures for " + context.getPackageName()), (Throwable)throwable);
            stringBuilder.append("Could not retrieve data: ");
            stringBuilder.append(throwable.getMessage());
        }
        return stringBuilder.toString();
    }
}

