/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra.collector;

import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;
import android.util.SparseArray;
import appplus.sharep.org.acra.ACRA;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public final class ConfigurationCollector {
    private static final String SUFFIX_MASK = "_MASK";
    private static final String FIELD_SCREENLAYOUT = "screenLayout";
    private static final String FIELD_UIMODE = "uiMode";
    private static final String FIELD_MNC = "mnc";
    private static final String FIELD_MCC = "mcc";
    private static final String PREFIX_UI_MODE = "UI_MODE_";
    private static final String PREFIX_TOUCHSCREEN = "TOUCHSCREEN_";
    private static final String PREFIX_SCREENLAYOUT = "SCREENLAYOUT_";
    private static final String PREFIX_ORIENTATION = "ORIENTATION_";
    private static final String PREFIX_NAVIGATIONHIDDEN = "NAVIGATIONHIDDEN_";
    private static final String PREFIX_NAVIGATION = "NAVIGATION_";
    private static final String PREFIX_KEYBOARDHIDDEN = "KEYBOARDHIDDEN_";
    private static final String PREFIX_KEYBOARD = "KEYBOARD_";
    private static final String PREFIX_HARDKEYBOARDHIDDEN = "HARDKEYBOARDHIDDEN_";
    private static SparseArray<String> mHardKeyboardHiddenValues = new SparseArray();
    private static SparseArray<String> mKeyboardValues = new SparseArray();
    private static SparseArray<String> mKeyboardHiddenValues = new SparseArray();
    private static SparseArray<String> mNavigationValues = new SparseArray();
    private static SparseArray<String> mNavigationHiddenValues = new SparseArray();
    private static SparseArray<String> mOrientationValues = new SparseArray();
    private static SparseArray<String> mScreenLayoutValues = new SparseArray();
    private static SparseArray<String> mTouchScreenValues = new SparseArray();
    private static SparseArray<String> mUiModeValues = new SparseArray();
    private static final HashMap<String, SparseArray<String>> mValueArrays = new HashMap();

    static {
        mValueArrays.put(PREFIX_HARDKEYBOARDHIDDEN, mHardKeyboardHiddenValues);
        mValueArrays.put(PREFIX_KEYBOARD, mKeyboardValues);
        mValueArrays.put(PREFIX_KEYBOARDHIDDEN, mKeyboardHiddenValues);
        mValueArrays.put(PREFIX_NAVIGATION, mNavigationValues);
        mValueArrays.put(PREFIX_NAVIGATIONHIDDEN, mNavigationHiddenValues);
        mValueArrays.put(PREFIX_ORIENTATION, mOrientationValues);
        mValueArrays.put(PREFIX_SCREENLAYOUT, mScreenLayoutValues);
        mValueArrays.put(PREFIX_TOUCHSCREEN, mTouchScreenValues);
        mValueArrays.put(PREFIX_UI_MODE, mUiModeValues);
        Field[] fieldArray = Configuration.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                String string = field.getName();
                try {
                    if (string.startsWith(PREFIX_HARDKEYBOARDHIDDEN)) {
                        mHardKeyboardHiddenValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_KEYBOARD)) {
                        mKeyboardValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_KEYBOARDHIDDEN)) {
                        mKeyboardHiddenValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_NAVIGATION)) {
                        mNavigationValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_NAVIGATIONHIDDEN)) {
                        mNavigationHiddenValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_ORIENTATION)) {
                        mOrientationValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_SCREENLAYOUT)) {
                        mScreenLayoutValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_TOUCHSCREEN)) {
                        mTouchScreenValues.put(field.getInt(null), (Object)string);
                    } else if (string.startsWith(PREFIX_UI_MODE)) {
                        mUiModeValues.put(field.getInt(null), (Object)string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalAccessException);
                }
            }
            ++n3;
        }
    }

    public static String toString(Configuration configuration) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = configuration.getClass().getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            try {
                if (!Modifier.isStatic(field.getModifiers())) {
                    String string = field.getName();
                    stringBuilder.append(string).append('=');
                    if (field.getType().equals(Integer.TYPE)) {
                        stringBuilder.append(ConfigurationCollector.getFieldValueName(configuration, field));
                    } else if (field.get(configuration) != null) {
                        stringBuilder.append(field.get(configuration).toString());
                    }
                    stringBuilder.append('\n');
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalAccessException);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static String getFieldValueName(Configuration configuration, Field field) throws IllegalAccessException {
        String string = field.getName();
        if (string.equals(FIELD_MCC) || string.equals(FIELD_MNC)) {
            return Integer.toString(field.getInt(configuration));
        }
        if (string.equals(FIELD_UIMODE)) {
            return ConfigurationCollector.activeFlags(mValueArrays.get(PREFIX_UI_MODE), field.getInt(configuration));
        }
        if (string.equals(FIELD_SCREENLAYOUT)) {
            return ConfigurationCollector.activeFlags(mValueArrays.get(PREFIX_SCREENLAYOUT), field.getInt(configuration));
        }
        SparseArray<String> sparseArray = mValueArrays.get(String.valueOf(string.toUpperCase()) + '_');
        if (sparseArray == null) {
            return Integer.toString(field.getInt(configuration));
        }
        String string2 = (String)sparseArray.get(field.getInt(configuration));
        if (string2 == null) {
            return Integer.toString(field.getInt(configuration));
        }
        return string2;
    }

    private static String activeFlags(SparseArray<String> sparseArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < sparseArray.size()) {
            int n4;
            int n5 = sparseArray.keyAt(n3);
            if (((String)sparseArray.get(n5)).endsWith(SUFFIX_MASK) && (n4 = n2 & n5) > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append((String)sparseArray.get(n4));
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String collectConfiguration(Context context) {
        try {
            Configuration configuration = context.getResources().getConfiguration();
            return ConfigurationCollector.toString(configuration);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve CrashConfiguration for : " + context.getPackageName()), (Throwable)runtimeException);
            return "Couldn't retrieve crash config";
        }
    }
}

