/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.content.Context;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.CrashReportFileNameParser;
import appplus.sharep.org.acra.CrashReportFinder;
import appplus.sharep.org.acra.CrashReportPersister;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.sender.ReportSender;
import appplus.sharep.org.acra.sender.ReportSenderException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

final class SendWorker
extends Thread {
    private final Context context;
    private final boolean sendOnlySilentReports;
    private final boolean approvePendingReports;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final List<ReportSender> reportSenders;

    public SendWorker(Context context, List<ReportSender> list, boolean bl, boolean bl2) {
        this.context = context;
        this.reportSenders = list;
        this.sendOnlySilentReports = bl;
        this.approvePendingReports = bl2;
    }

    @Override
    public void run() {
        if (this.approvePendingReports) {
            this.approvePendingReports();
        }
        this.checkAndSendReports(this.context, this.sendOnlySilentReports);
    }

    private void approvePendingReports() {
        String[] stringArray;
        Log.d((String)ACRA.LOG_TAG, (String)"Mark all pending reports as approved.");
        CrashReportFinder crashReportFinder = new CrashReportFinder(this.context);
        String[] stringArray2 = stringArray = crashReportFinder.getCrashReportFiles();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (!this.fileNameParser.isApproved(string)) {
                File file = new File(this.context.getFilesDir(), string);
                String string2 = string.replace(".stacktrace", "-approved.stacktrace");
                File file2 = new File(this.context.getFilesDir(), string2);
                if (!file.renameTo(file2)) {
                    Log.e((String)ACRA.LOG_TAG, (String)("Could not rename approved report from " + file + " to " + file2));
                }
            }
            ++n3;
        }
    }

    private void checkAndSendReports(Context context, boolean bl) {
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - start");
        CrashReportFinder crashReportFinder = new CrashReportFinder(context);
        Object[] objectArray = crashReportFinder.getCrashReportFiles();
        Arrays.sort(objectArray);
        int n2 = 0;
        Object[] objectArray2 = objectArray;
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Object object = objectArray2[n4];
            if (!bl || this.fileNameParser.isSilent((String)object)) {
                if (n2 >= 5) break;
                Log.i((String)ACRA.LOG_TAG, (String)("Sending file " + (String)object));
                try {
                    CrashReportPersister crashReportPersister = new CrashReportPersister(context);
                    CrashReportData crashReportData = crashReportPersister.load((String)object);
                    this.sendCrashReport(crashReportData);
                    this.deleteFile(context, (String)object);
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash reports for " + (String)object), (Throwable)runtimeException);
                    this.deleteFile(context, (String)object);
                    break;
                }
                catch (IOException iOException) {
                    Log.e((String)ACRA.LOG_TAG, (String)("Failed to load crash report for " + (String)object), (Throwable)iOException);
                    this.deleteFile(context, (String)object);
                    break;
                }
                catch (ReportSenderException reportSenderException) {
                    Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash report for " + (String)object), (Throwable)reportSenderException);
                }
                ++n2;
            }
            ++n4;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - finish");
    }

    private void sendCrashReport(CrashReportData crashReportData) throws ReportSenderException {
        if (!ACRA.isDebuggable() || ACRA.getConfig().sendReportsInDevMode()) {
            boolean bl = false;
            for (ReportSender reportSender : this.reportSenders) {
                try {
                    reportSender.send(crashReportData);
                    bl = true;
                }
                catch (ReportSenderException reportSenderException) {
                    if (!bl) {
                        throw reportSenderException;
                    }
                    Log.w((String)ACRA.LOG_TAG, (String)("ReportSender of class " + reportSender.getClass().getName() + " failed but other senders completed their task. ACRA will not send this report again."));
                }
            }
        }
    }

    private void deleteFile(Context context, String string) {
        boolean bl = context.deleteFile(string);
        if (!bl) {
            Log.w((String)ACRA.LOG_TAG, (String)("Could not delete error report : " + string));
        }
    }
}

