/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.text.format.Time;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.ACRAConfiguration;
import appplus.sharep.org.acra.ACRAConstants;
import appplus.sharep.org.acra.CrashReportDialog;
import appplus.sharep.org.acra.CrashReportFileNameParser;
import appplus.sharep.org.acra.CrashReportFinder;
import appplus.sharep.org.acra.CrashReportPersister;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.ReportingInteractionMode;
import appplus.sharep.org.acra.SendWorker;
import appplus.sharep.org.acra.UmengUtils;
import appplus.sharep.org.acra.collector.Compatibility;
import appplus.sharep.org.acra.collector.ConfigurationCollector;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.collector.CrashReportDataFactory;
import appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat.ActivityLifecycleCallbacksCompat;
import appplus.sharep.org.acra.jraf.android.util.activitylifecyclecallbackscompat.ApplicationHelper;
import appplus.sharep.org.acra.sender.EmailIntentSender;
import appplus.sharep.org.acra.sender.GoogleFormSender;
import appplus.sharep.org.acra.sender.HttpSender;
import appplus.sharep.org.acra.sender.ReportSender;
import appplus.sharep.org.acra.util.PackageManagerWrapper;
import appplus.sharep.org.acra.util.ToastSender;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private boolean enabled = false;
    private final Application mContext;
    private final SharedPreferences prefs;
    private final List<ReportSender> mReportSenders = new ArrayList<ReportSender>();
    private final CrashReportDataFactory crashReportDataFactory;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private Thread brokenThread;
    private Throwable unhandledThrowable;
    private transient Activity lastActivityCreated;
    private static boolean toastWaitEnded = true;
    private static int mNotificationCounter = 0;
    private ArrayList<Thread.UncaughtExceptionHandler> queueDef = new ArrayList();
    private int queueIndex = 0;
    private static int CHECK_DURATION = 5000;

    ErrorReporter(Application application, SharedPreferences sharedPreferences, boolean bl) {
        this.mContext = application;
        this.prefs = sharedPreferences;
        this.enabled = bl;
        String string = ConfigurationCollector.collectConfiguration((Context)this.mContext);
        Time time = new Time();
        time.setToNow();
        if (Compatibility.getAPILevel() >= 14) {
            ApplicationHelper.registerActivityLifecycleCallbacks(application, new ActivityLifecycleCallbacksCompat(){

                @Override
                public void onActivityCreated(Activity activity, Bundle bundle) {
                    if (!(activity instanceof CrashReportDialog)) {
                        ErrorReporter.this.lastActivityCreated = activity;
                    }
                }

                @Override
                public void onActivityStarted(Activity activity) {
                }

                @Override
                public void onActivityResumed(Activity activity) {
                }

                @Override
                public void onActivityPaused(Activity activity) {
                }

                @Override
                public void onActivityStopped(Activity activity) {
                }

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                @Override
                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
        this.crashReportDataFactory = new CrashReportDataFactory((Context)this.mContext, sharedPreferences, time, string);
        this.addQueue();
        new Thread(){

            @Override
            public void run() {
                int n2 = 200;
                int n3 = CHECK_DURATION / n2;
                while (n3 > 0) {
                    try {
                        2.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    --n3;
                    ErrorReporter.this.addQueue();
                }
            }
        }.start();
        this.checkReportsOnApplicationStart();
    }

    private void addQueue() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(uncaughtExceptionHandler instanceof ErrorReporter)) {
            if (this.queueIndex == this.queueDef.size()) {
                ++this.queueIndex;
            }
            this.queueDef.add(uncaughtExceptionHandler);
            Thread.setDefaultUncaughtExceptionHandler(this);
            Log.v((String)"---errorEeporter--addQueue", (String)String.valueOf(this.queueDef.size()));
        }
    }

    public static ErrorReporter getInstance() {
        return ACRA.getErrorReporter();
    }

    @Deprecated
    public void addCustomData(String string, String string2) {
        this.crashReportDataFactory.putCustomData(string, string2);
    }

    public String putCustomData(String string, String string2) {
        return this.crashReportDataFactory.putCustomData(string, string2);
    }

    public String removeCustomData(String string) {
        return this.crashReportDataFactory.removeCustomData(string);
    }

    public String getCustomData(String string) {
        return this.crashReportDataFactory.getCustomData(string);
    }

    public void addReportSender(ReportSender reportSender) {
        this.mReportSenders.add(reportSender);
    }

    public void removeReportSender(ReportSender reportSender) {
        this.mReportSenders.remove(reportSender);
    }

    public void removeReportSenders(Class<?> clazz) {
        if (ReportSender.class.isAssignableFrom(clazz)) {
            for (ReportSender reportSender : this.mReportSenders) {
                if (!clazz.isInstance(reportSender)) continue;
                this.mReportSenders.remove(reportSender);
            }
        }
    }

    public void removeAllReportSenders() {
        this.mReportSenders.clear();
    }

    public void setReportSender(ReportSender reportSender) {
        this.removeAllReportSenders();
        this.addReportSender(reportSender);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        try {
            if (this.nextQueue(thread, throwable)) {
                return;
            }
            --this.queueIndex;
            if (!this.enabled) {
                this.nextQueue(thread, throwable);
                return;
            }
            Log.v((String)"---errorEeporter--", (String)"current");
            this.brokenThread = thread;
            this.unhandledThrowable = throwable;
            Log.e((String)ACRA.LOG_TAG, (String)("ACRA caught a " + throwable.getClass().getSimpleName() + " exception for " + this.mContext.getPackageName() + ". Building report."));
            this.handleException(throwable, ACRA.getConfig().mode(), false, true);
        }
        catch (Throwable throwable2) {
            this.nextQueue(thread, throwable);
        }
    }

    private boolean nextQueue(Thread thread, Throwable throwable) {
        if (this.queueIndex < 0) {
            this.queueIndex = this.queueDef.size();
            return false;
        }
        if (this.queueIndex < this.queueDef.size()) {
            Log.v((String)"---errorEeporter--", (String)("next" + String.valueOf(this.queueIndex)));
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.queueDef.get(this.queueIndex);
            this.queueIndex = this.queueIndex == 0 ? this.queueDef.size() : --this.queueIndex;
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
            }
            return true;
        }
        return false;
    }

    private void endApplication() {
        if (ACRA.getConfig().mode() == ReportingInteractionMode.SILENT || ACRA.getConfig().mode() == ReportingInteractionMode.TOAST && ACRA.getConfig().forceCloseDialogAfterToast()) {
            Log.v((String)"---checkUmengFile---endApplication()", (String)"endApplication()");
            if (new UmengUtils().isSDKcrash(this.unhandledThrowable)) {
                Log.e((String)ACRA.LOG_TAG, (String)"isSDKcrash");
                if (this.lastActivityCreated != null) {
                    this.lastActivityCreated.finish();
                    this.lastActivityCreated = null;
                }
                this.queueIndex = this.queueDef.size();
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            } else {
                this.nextQueue(this.brokenThread, this.unhandledThrowable);
            }
        } else {
            Log.e((String)ACRA.LOG_TAG, (String)(String.valueOf(this.mContext.getPackageName()) + " fatal error : " + this.unhandledThrowable.getMessage()), (Throwable)this.unhandledThrowable);
            if (this.lastActivityCreated != null) {
                Log.i((String)ACRA.LOG_TAG, (String)"Finishing the last Activity prior to killing the Process");
                this.lastActivityCreated.finish();
                Log.i((String)ACRA.LOG_TAG, (String)("Finished " + this.lastActivityCreated.getClass()));
                this.lastActivityCreated = null;
            }
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
    }

    public void handleSilentException(Throwable throwable) {
        if (this.enabled) {
            this.handleException(throwable, ReportingInteractionMode.SILENT, true, false);
            Log.d((String)ACRA.LOG_TAG, (String)"ACRA sent Silent report.");
            return;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled. Silent report not sent.");
    }

    public void setEnabled(boolean bl) {
        Log.i((String)ACRA.LOG_TAG, (String)("ACRA is " + (bl ? "enabled" : "disabled") + " for " + this.mContext.getPackageName()));
        this.enabled = bl;
    }

    SendWorker startSendingReports(boolean bl, boolean bl2) {
        SendWorker sendWorker = new SendWorker((Context)this.mContext, this.mReportSenders, bl, bl2);
        sendWorker.start();
        return sendWorker;
    }

    void deletePendingReports() {
        this.deletePendingReports(true, true, 0);
    }

    public void checkReportsOnApplicationStart() {
        String[] stringArray;
        Object object;
        boolean bl;
        long l2 = this.prefs.getInt("acra.lastVersionNr", 0);
        PackageManagerWrapper packageManagerWrapper = new PackageManagerWrapper((Context)this.mContext);
        PackageInfo packageInfo = packageManagerWrapper.getPackageInfo();
        boolean bl2 = bl = packageInfo != null && (long)packageInfo.versionCode > l2;
        if (bl) {
            if (ACRA.getConfig().deleteOldUnsentReportsOnApplicationStart()) {
                this.deletePendingReports();
            }
            object = this.prefs.edit();
            object.putInt("acra.lastVersionNr", packageInfo.versionCode);
            object.commit();
        }
        if ((ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION || ACRA.getConfig().mode() == ReportingInteractionMode.DIALOG) && ACRA.getConfig().deleteUnapprovedReportsOnApplicationStart()) {
            this.deletePendingNonApprovedReports(true);
        }
        if ((stringArray = ((CrashReportFinder)(object = new CrashReportFinder((Context)this.mContext))).getCrashReportFiles()) != null && stringArray.length > 0) {
            ReportingInteractionMode reportingInteractionMode = ACRA.getConfig().mode();
            stringArray = ((CrashReportFinder)object).getCrashReportFiles();
            boolean bl3 = this.containsOnlySilentOrApprovedReports(stringArray);
            if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || bl3 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG)) {
                if (reportingInteractionMode == ReportingInteractionMode.TOAST && !bl3) {
                    ToastSender.sendToast((Context)this.mContext, ACRA.getConfig().resToastText(), 1);
                }
                Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #checkReportOnApplicationStart");
                this.startSendingReports(false, false);
            } else if (ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION) {
                this.notifySendReport(this.getLatestNonSilentReport(stringArray));
            } else {
                ACRA.getConfig().mode();
            }
        }
    }

    void deletePendingNonApprovedReports(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.deletePendingReports(false, true, n2);
    }

    public void handleException(Throwable throwable, boolean bl) {
        this.handleException(throwable, ACRA.getConfig().mode(), false, bl);
    }

    public void handleException(Throwable throwable) {
        this.handleException(throwable, ACRA.getConfig().mode(), false, false);
    }

    private void handleException(Throwable throwable, ReportingInteractionMode reportingInteractionMode, boolean bl, final boolean bl2) {
        boolean bl3;
        if (!this.enabled) {
            return;
        }
        boolean bl4 = false;
        if (reportingInteractionMode == null) {
            reportingInteractionMode = ACRA.getConfig().mode();
        } else if (reportingInteractionMode == ReportingInteractionMode.SILENT && ACRA.getConfig().mode() != ReportingInteractionMode.SILENT) {
            bl4 = true;
        }
        if (throwable == null) {
            throwable = new Exception("Report requested by developer");
        }
        boolean bl5 = bl3 = reportingInteractionMode == ReportingInteractionMode.TOAST || ACRA.getConfig().resToastText() != 0 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG);
        if (bl3) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    ToastSender.sendToast((Context)ErrorReporter.this.mContext, ACRA.getConfig().resToastText(), 1);
                    Looper.loop();
                }
            }.start();
        }
        CrashReportData crashReportData = this.crashReportDataFactory.createCrashData(throwable, bl, this.brokenThread);
        final String string = this.getReportFileName(crashReportData);
        this.saveCrashReportFile(string, crashReportData);
        SendWorker sendWorker = null;
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || this.prefs.getBoolean("acra.alwaysaccept", false)) {
            Log.d((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #handleException");
            sendWorker = this.startSendingReports(bl4, true);
        } else if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            Log.d((String)ACRA.LOG_TAG, (String)"Notification will be created on application start.");
        }
        if (bl3) {
            toastWaitEnded = false;
            new Thread(){

                @Override
                public void run() {
                    Time time = new Time();
                    Time time2 = new Time();
                    time.setToNow();
                    long l2 = time.toMillis(false);
                    long l3 = 0L;
                    while (l3 < 3000L) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)ACRA.LOG_TAG, (String)"Interrupted while waiting for Toast to end.", (Throwable)interruptedException);
                        }
                        time2.setToNow();
                        l3 = time2.toMillis(false) - l2;
                    }
                    toastWaitEnded = true;
                }
            }.start();
        }
        final SendWorker sendWorker2 = sendWorker;
        final boolean bl6 = reportingInteractionMode == ReportingInteractionMode.DIALOG && !this.prefs.getBoolean("acra.alwaysaccept", false);
        new Thread(){

            @Override
            public void run() {
                Log.d((String)ACRA.LOG_TAG, (String)"Waiting for Toast + worker...");
                while (!toastWaitEnded || sendWorker2 != null && sendWorker2.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)interruptedException);
                    }
                }
                if (bl6) {
                    Log.d((String)ACRA.LOG_TAG, (String)"About to create DIALOG from #handleException");
                    ErrorReporter.this.notifyDialog(string);
                }
                Log.d((String)ACRA.LOG_TAG, (String)("Wait for Toast + worker ended. Kill Application ? " + bl2));
                if (bl2) {
                    ErrorReporter.this.endApplication();
                }
            }
        }.start();
    }

    void notifyDialog(String string) {
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Dialog for " + string));
        Intent intent = new Intent((Context)this.mContext, CrashReportDialog.class);
        intent.putExtra("REPORT_FILE_NAME", string);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    private void notifySendReport(String string) {
        PendingIntent pendingIntent;
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        int n2 = aCRAConfiguration.resNotifIcon();
        CharSequence charSequence = this.mContext.getText(aCRAConfiguration.resNotifTickerText());
        long l2 = System.currentTimeMillis();
        Notification notification = new Notification(n2, charSequence, l2);
        CharSequence charSequence2 = this.mContext.getText(aCRAConfiguration.resNotifTitle());
        CharSequence charSequence3 = this.mContext.getText(aCRAConfiguration.resNotifText());
        Intent intent = new Intent((Context)this.mContext, CrashReportDialog.class);
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Notification for " + string));
        intent.putExtra("REPORT_FILE_NAME", string);
        PendingIntent pendingIntent2 = PendingIntent.getActivity((Context)this.mContext, (int)mNotificationCounter++, (Intent)intent, (int)0x8000000);
        notification.setLatestEventInfo((Context)this.mContext, charSequence2, charSequence3, pendingIntent2);
        Intent intent2 = new Intent((Context)this.mContext, CrashReportDialog.class);
        intent2.putExtra("FORCE_CANCEL", true);
        notification.deleteIntent = pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)-1, (Intent)intent2, (int)0);
        notificationManager.notify(666, notification);
    }

    private String getReportFileName(CrashReportData crashReportData) {
        Time time = new Time();
        time.setToNow();
        long l2 = time.toMillis(false);
        String string = crashReportData.getProperty(ReportField.IS_SILENT);
        return l2 + (string != null ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
    }

    private void saveCrashReportFile(String string, CrashReportData crashReportData) {
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Writing crash report file " + string + "."));
            CrashReportPersister crashReportPersister = new CrashReportPersister((Context)this.mContext);
            crashReportPersister.store(crashReportData, string);
        }
        catch (Exception exception) {
            Log.e((String)ACRA.LOG_TAG, (String)"An error occurred while writing the report file...", (Throwable)exception);
        }
    }

    private String getLatestNonSilentReport(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n2 = stringArray.length - 1;
            while (n2 >= 0) {
                if (!this.fileNameParser.isSilent(stringArray[n2])) {
                    return stringArray[n2];
                }
                --n2;
            }
            return stringArray[stringArray.length - 1];
        }
        return null;
    }

    private void deletePendingReports(boolean bl, boolean bl2, int n2) {
        CrashReportFinder crashReportFinder = new CrashReportFinder((Context)this.mContext);
        Object[] objectArray = crashReportFinder.getCrashReportFiles();
        Arrays.sort(objectArray);
        if (objectArray != null) {
            int n3 = 0;
            while (n3 < objectArray.length - n2) {
                Object object = objectArray[n3];
                boolean bl3 = this.fileNameParser.isApproved((String)object);
                if (bl3 && bl || !bl3 && bl2) {
                    File file = new File(this.mContext.getFilesDir(), (String)object);
                    ACRA.log.d(ACRA.LOG_TAG, "Deleting file " + (String)object);
                    if (!file.delete()) {
                        Log.e((String)ACRA.LOG_TAG, (String)("Could not delete report : " + file));
                    }
                }
                ++n3;
            }
        }
    }

    private boolean containsOnlySilentOrApprovedReports(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (!this.fileNameParser.isApproved(string)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void setDefaultReportSenders() {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        Application application = ACRA.getApplication();
        this.removeAllReportSenders();
        if (!"".equals(aCRAConfiguration.mailTo())) {
            Log.w((String)ACRA.LOG_TAG, (String)(String.valueOf(application.getPackageName()) + " reports will be sent by email (if accepted by user)."));
            this.setReportSender(new EmailIntentSender((Context)application));
            return;
        }
        PackageManagerWrapper packageManagerWrapper = new PackageManagerWrapper((Context)application);
        if (!packageManagerWrapper.hasPermission("android.permission.INTERNET")) {
            Log.e((String)ACRA.LOG_TAG, (String)(String.valueOf(application.getPackageName()) + " should be granted permission " + "android.permission.INTERNET" + " if you want your crash reports to be sent. If you don't want to add this permission to your application you can also enable sending reports by email. If this is your will then provide your email address in @ReportsCrashes(mailTo=\"your.account@domain.com\""));
            return;
        }
        if (aCRAConfiguration.formUri() != null && !"".equals(aCRAConfiguration.formUri())) {
            this.setReportSender(new HttpSender(ACRA.getConfig().httpMethod(), ACRA.getConfig().reportType(), null));
            return;
        }
        if (aCRAConfiguration.formKey() != null && !"".equals(aCRAConfiguration.formKey().trim())) {
            this.addReportSender(new GoogleFormSender());
        }
    }
}

