/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.content.Context;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Map;

final class CrashReportPersister {
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private static final String LINE_SEPARATOR = "\n";
    private final Context context;

    CrashReportPersister(Context context) {
        this.context = context;
    }

    public CrashReportData load(String string) throws IOException {
        FileInputStream fileInputStream = this.context.openFileInput(string);
        if (fileInputStream == null) {
            throw new IllegalArgumentException("Invalid crash report fileName : " + string);
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            bufferedInputStream.mark(Integer.MAX_VALUE);
            boolean bl = this.isEbcdic(bufferedInputStream);
            bufferedInputStream.reset();
            if (!bl) {
                CrashReportData crashReportData = this.load(new InputStreamReader((InputStream)bufferedInputStream, "ISO8859-1"));
                return crashReportData;
            }
            CrashReportData crashReportData = this.load(new InputStreamReader(bufferedInputStream));
            return crashReportData;
        }
        finally {
            fileInputStream.close();
        }
    }

    public void store(CrashReportData crashReportData, String string) throws IOException {
        FileOutputStream fileOutputStream = this.context.openFileOutput(string, 0);
        try {
            StringBuilder stringBuilder = new StringBuilder(200);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO8859_1");
            for (Map.Entry entry : crashReportData.entrySet()) {
                String string2 = ((ReportField)((Object)entry.getKey())).toString();
                this.dumpString(stringBuilder, string2, true);
                stringBuilder.append('=');
                this.dumpString(stringBuilder, (String)entry.getValue(), false);
                stringBuilder.append(LINE_SEPARATOR);
                outputStreamWriter.write(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            outputStreamWriter.flush();
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private boolean isEbcdic(BufferedInputStream bufferedInputStream) throws IOException {
        byte by;
        while ((by = (byte)bufferedInputStream.read()) != -1) {
            if (by == 35 || by == 10 || by == 61) {
                return false;
            }
            if (by != 21) continue;
            return true;
        }
        return false;
    }

    private synchronized CrashReportData load(Reader reader) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char[] cArray = new char[40];
        int n6 = 0;
        int n7 = -1;
        boolean bl = true;
        CrashReportData crashReportData = new CrashReportData();
        BufferedReader bufferedReader = new BufferedReader(reader, 8192);
        block17: while ((n2 = bufferedReader.read()) != -1) {
            Object object;
            int n8 = n2;
            if (n6 == cArray.length) {
                object = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, object, 0, n6);
                cArray = object;
            }
            if (n3 == 2) {
                int n9 = Character.digit((char)n8, 16);
                if (n9 >= 0) {
                    n4 = (n4 << 4) + n9;
                    if (++n5 < 4) {
                        continue;
                    }
                } else if (n5 <= 4) {
                    throw new IllegalArgumentException("luni.09");
                }
                n3 = 0;
                cArray[n6++] = (char)n4;
                if (n8 != 10 && n8 != 133) continue;
            }
            if (n3 == 1) {
                n3 = 0;
                switch (n8) {
                    case 13: {
                        n3 = 3;
                        continue block17;
                    }
                    case 10: 
                    case 133: {
                        n3 = 5;
                        continue block17;
                    }
                    case 98: {
                        n8 = 8;
                        break;
                    }
                    case 102: {
                        n8 = 12;
                        break;
                    }
                    case 110: {
                        n8 = 10;
                        break;
                    }
                    case 114: {
                        n8 = 13;
                        break;
                    }
                    case 116: {
                        n8 = 9;
                        break;
                    }
                    case 117: {
                        n3 = 2;
                        n5 = 0;
                        n4 = 0;
                        continue block17;
                    }
                }
            } else {
                switch (n8) {
                    case 33: 
                    case 35: {
                        if (!bl) break;
                        while ((n2 = bufferedReader.read()) != -1 && (n8 = (int)((char)n2)) != 13 && n8 != 10 && n8 != 133) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (n3 == 3) {
                            n3 = 5;
                            continue block17;
                        }
                    }
                    case 13: 
                    case 133: {
                        n3 = 0;
                        bl = true;
                        if (n6 > 0 || n6 == 0 && n7 == 0) {
                            if (n7 == -1) {
                                n7 = n6;
                            }
                            object = new String(cArray, 0, n6);
                            crashReportData.put(Enum.valueOf(ReportField.class, ((String)object).substring(0, n7)), ((String)object).substring(n7));
                        }
                        n7 = -1;
                        n6 = 0;
                        continue block17;
                    }
                    case 92: {
                        if (n3 == 4) {
                            n7 = n6;
                        }
                        n3 = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (n7 != -1) break;
                        n3 = 0;
                        n7 = n6;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)n8)) {
                    if (n3 == 3) {
                        n3 = 5;
                    }
                    if (n6 == 0 || n6 == n7 || n3 == 5) continue;
                    if (n7 == -1) {
                        n3 = 4;
                        continue;
                    }
                }
                if (n3 == 5 || n3 == 3) {
                    n3 = 0;
                }
            }
            bl = false;
            if (n3 == 4) {
                n7 = n6;
                n3 = 0;
            }
            cArray[n6++] = n8;
        }
        if (n3 == 2 && n5 <= 4) {
            throw new IllegalArgumentException("luni.08");
        }
        if (n7 == -1 && n6 > 0) {
            n7 = n6;
        }
        if (n7 >= 0) {
            String string = new String(cArray, 0, n6);
            ReportField reportField = Enum.valueOf(ReportField.class, string.substring(0, n7));
            String string2 = string.substring(n7);
            if (n3 == 1) {
                string2 = String.valueOf(string2) + "\u0000";
            }
            crashReportData.put(reportField, string2);
        }
        return crashReportData;
    }

    private void dumpString(StringBuilder stringBuilder, String string, boolean bl) {
        int n2 = 0;
        if (!bl && n2 < string.length() && string.charAt(n2) == ' ') {
            stringBuilder.append("\\ ");
            ++n2;
        }
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(c2) >= 0 || bl && c2 == ' ') {
                        stringBuilder.append('\\');
                    }
                    if (c2 >= ' ' && c2 <= '~') {
                        stringBuilder.append(c2);
                        break;
                    }
                    String string2 = Integer.toHexString(c2);
                    stringBuilder.append("\\u");
                    int n3 = 0;
                    while (n3 < 4 - string2.length()) {
                        stringBuilder.append("0");
                        ++n3;
                    }
                    stringBuilder.append(string2);
                }
            }
            ++n2;
        }
    }
}

