/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.content.Context;
import android.util.Log;
import appplus.sharep.org.acra.ACRA;
import java.io.File;
import java.io.FilenameFilter;

final class CrashReportFinder {
    private final Context context;

    public CrashReportFinder(Context context) {
        this.context = context;
    }

    public String[] getCrashReportFiles() {
        if (this.context == null) {
            Log.e((String)ACRA.LOG_TAG, (String)"Trying to get ACRA reports but ACRA is not initialized.");
            return new String[0];
        }
        File file = this.context.getFilesDir();
        if (file == null) {
            Log.w((String)ACRA.LOG_TAG, (String)"Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
            return new String[0];
        }
        Log.d((String)ACRA.LOG_TAG, (String)("Looking for error files in " + file.getAbsolutePath()));
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".stacktrace");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        return stringArray == null ? new String[]{} : stringArray;
    }
}

