/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import appplus.sharep.org.acra.ACRA;
import appplus.sharep.org.acra.CrashReportPersister;
import appplus.sharep.org.acra.ReportField;
import appplus.sharep.org.acra.collector.CrashReportData;
import appplus.sharep.org.acra.util.ToastSender;
import java.io.IOException;

public class CrashReportDialog
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private SharedPreferences prefs;
    private EditText userComment;
    private EditText userEmail;
    String mReportFileName;
    AlertDialog mDialog;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        boolean bl = this.getIntent().getBooleanExtra("FORCE_CANCEL", false);
        if (bl) {
            ACRA.log.d(ACRA.LOG_TAG, "Forced reports deletion.");
            this.cancelReports();
            this.finish();
            return;
        }
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        Log.d((String)ACRA.LOG_TAG, (String)("Opening CrashReportDialog for " + this.mReportFileName));
        if (this.mReportFileName == null) {
            this.finish();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        int n2 = ACRA.getConfig().resDialogTitle();
        if (n2 != 0) {
            builder.setTitle(n2);
        }
        if ((n2 = ACRA.getConfig().resDialogIcon()) != 0) {
            builder.setIcon(n2);
        }
        builder.setView(this.buildCustomView(bundle));
        builder.setPositiveButton(17039370, (DialogInterface.OnClickListener)this);
        builder.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this);
        this.cancelNotification();
        this.mDialog = builder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mDialog.show();
    }

    private View buildCustomView(Bundle bundle) {
        int n2;
        Object object;
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        linearLayout.setPadding(10, 10, 10, 10);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        linearLayout.setFocusable(true);
        linearLayout.setFocusableInTouchMode(true);
        ScrollView scrollView = new ScrollView((Context)this);
        linearLayout.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout linearLayout2 = new LinearLayout((Context)this);
        linearLayout2.setOrientation(1);
        scrollView.addView((View)linearLayout2);
        TextView textView = new TextView((Context)this);
        int n3 = ACRA.getConfig().resDialogText();
        if (n3 != 0) {
            textView.setText(this.getText(n3));
        }
        linearLayout2.addView((View)textView);
        int n4 = ACRA.getConfig().resDialogCommentPrompt();
        if (n4 != 0) {
            TextView textView2 = new TextView((Context)this);
            textView2.setText(this.getText(n4));
            textView2.setPadding(textView2.getPaddingLeft(), 10, textView2.getPaddingRight(), textView2.getPaddingBottom());
            linearLayout2.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            if (bundle != null && (object = bundle.getString(STATE_COMMENT)) != null) {
                this.userComment.setText((CharSequence)object);
            }
            linearLayout2.addView((View)this.userComment);
        }
        if ((n2 = ACRA.getConfig().resDialogEmailPrompt()) != 0) {
            object = new TextView((Context)this);
            object.setText(this.getText(n2));
            object.setPadding(object.getPaddingLeft(), 10, object.getPaddingRight(), object.getPaddingBottom());
            linearLayout2.addView((View)object);
            this.userEmail = new EditText((Context)this);
            this.userEmail.setSingleLine();
            this.userEmail.setInputType(33);
            this.prefs = this.getSharedPreferences(ACRA.getConfig().sharedPreferencesName(), ACRA.getConfig().sharedPreferencesMode());
            String string = null;
            if (bundle != null) {
                string = bundle.getString(STATE_EMAIL);
            }
            if (string != null) {
                this.userEmail.setText((CharSequence)string);
            } else {
                this.userEmail.setText((CharSequence)this.prefs.getString("acra.user.email", ""));
            }
            linearLayout2.addView((View)this.userEmail);
        }
        return linearLayout;
    }

    protected void cancelNotification() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(666);
    }

    public void onClick(DialogInterface dialogInterface, int n2) {
        if (n2 == -1) {
            this.sendCrash();
        } else {
            this.cancelReports();
        }
        this.finish();
    }

    private void cancelReports() {
        ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
    }

    private void sendCrash() {
        CrashReportPersister crashReportPersister;
        String string;
        String string2;
        String string3 = string2 = this.userComment != null ? this.userComment.getText().toString() : "";
        if (this.prefs != null && this.userEmail != null) {
            string = this.userEmail.getText().toString();
            crashReportPersister = this.prefs.edit();
            crashReportPersister.putString("acra.user.email", string);
            crashReportPersister.commit();
        } else {
            string = "";
        }
        crashReportPersister = new CrashReportPersister(this.getApplicationContext());
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Add user comment to " + this.mReportFileName));
            CrashReportData crashReportData = crashReportPersister.load(this.mReportFileName);
            crashReportData.put(ReportField.USER_COMMENT, string2);
            crashReportData.put(ReportField.USER_EMAIL, string);
            crashReportPersister.store(crashReportData, this.mReportFileName);
        }
        catch (IOException iOException) {
            Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)iOException);
        }
        Log.v((String)ACRA.LOG_TAG, (String)"About to start SenderWorker from CrashReportDialog");
        ACRA.getErrorReporter().startSendingReports(false, true);
        int n2 = ACRA.getConfig().resDialogOkToast();
        if (n2 != 0) {
            ToastSender.sendToast(this.getApplicationContext(), n2, 1);
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (this.userComment != null && this.userComment.getText() != null) {
            bundle.putString(STATE_COMMENT, this.userComment.getText().toString());
        }
        if (this.userEmail != null && this.userEmail.getText() != null) {
            bundle.putString(STATE_EMAIL, this.userEmail.getText().toString());
        }
    }

    public void onDismiss(DialogInterface dialogInterface) {
        this.finish();
    }
}

