/*
 * Decompiled with CFR 0.152.
 */
package appplus.sharep.org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import appplus.sharep.org.acra.ACRAConfiguration;
import appplus.sharep.org.acra.ACRAConfigurationException;
import appplus.sharep.org.acra.AnnotationProxy;
import appplus.sharep.org.acra.ErrorReporter;
import appplus.sharep.org.acra.annotation.ReportsCrashes;
import appplus.sharep.org.acra.log.ACRALog;
import appplus.sharep.org.acra.log.AndroidLogDelegate;

public class ACRA {
    public static final boolean DEV_LOGGING = false;
    public static final String LOG_TAG = ACRA.class.getSimpleName();
    public static ACRALog log = new AndroidLogDelegate();
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    private static AnnotationProxy mAnnotationProxy;
    private static Application mApplication;
    private static ReportsCrashes mReportsCrashes;
    private static ErrorReporter errorReporterSingleton;
    private static SharedPreferences.OnSharedPreferenceChangeListener mPrefListener;
    private static ACRAConfiguration configProxy;

    public static void init(Application application, AnnotationProxy annotationProxy) {
        if (mApplication != null) {
            log.w(LOG_TAG, "ACRA#init called more than once. Won't do anything more.");
            return;
        }
        if (mAnnotationProxy != null) {
            return;
        }
        mApplication = application;
        mAnnotationProxy = annotationProxy;
        mReportsCrashes = mAnnotationProxy.getClass().getAnnotation(ReportsCrashes.class);
        if (mReportsCrashes == null) {
            log.e(LOG_TAG, "ACRA#init called but no ReportsCrashes annotation on Application " + mApplication.getPackageName());
            return;
        }
        SharedPreferences sharedPreferences = ACRA.getACRASharedPreferences();
        try {
            ACRA.checkCrashResources();
            log.d(LOG_TAG, "ACRA is enabled for " + mApplication.getPackageName() + ", intializing...");
            boolean bl = !ACRA.shouldDisableACRA(sharedPreferences);
            ErrorReporter errorReporter = new ErrorReporter(mApplication, sharedPreferences, bl);
            errorReporter.setDefaultReportSenders();
            errorReporterSingleton = errorReporter;
        }
        catch (ACRAConfigurationException aCRAConfigurationException) {
            log.w(LOG_TAG, "Error : ", aCRAConfigurationException);
        }
        mPrefListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string) {
                if (ACRA.PREF_DISABLE_ACRA.equals(string) || ACRA.PREF_ENABLE_ACRA.equals(string)) {
                    boolean bl = !ACRA.shouldDisableACRA(sharedPreferences);
                    ACRA.getErrorReporter().setEnabled(bl);
                }
            }
        };
        sharedPreferences.registerOnSharedPreferenceChangeListener(mPrefListener);
    }

    public static ErrorReporter getErrorReporter() {
        if (errorReporterSingleton == null) {
            throw new IllegalStateException("Cannot access ErrorReporter before ACRA#init");
        }
        return errorReporterSingleton;
    }

    private static boolean shouldDisableACRA(SharedPreferences sharedPreferences) {
        boolean bl = false;
        try {
            boolean bl2 = sharedPreferences.getBoolean(PREF_ENABLE_ACRA, true);
            bl = sharedPreferences.getBoolean(PREF_DISABLE_ACRA, !bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static void checkCrashResources() throws ACRAConfigurationException {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        switch (aCRAConfiguration.mode()) {
            case TOAST: {
                if (aCRAConfiguration.resToastText() != 0) break;
                throw new ACRAConfigurationException("TOAST mode: you have to define the resToastText parameter in your application @ReportsCrashes() annotation.");
            }
            case NOTIFICATION: {
                if (aCRAConfiguration.resNotifTickerText() != 0 && aCRAConfiguration.resNotifTitle() != 0 && aCRAConfiguration.resNotifText() != 0 && aCRAConfiguration.resDialogText() != 0) break;
                throw new ACRAConfigurationException("NOTIFICATION mode: you have to define at least the resNotifTickerText, resNotifTitle, resNotifText, resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
            case DIALOG: {
                if (aCRAConfiguration.resDialogText() != 0) break;
                throw new ACRAConfigurationException("DIALOG mode: you have to define at least the resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
        }
    }

    public static SharedPreferences getACRASharedPreferences() {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        if (!"".equals(aCRAConfiguration.sharedPreferencesName())) {
            return mApplication.getSharedPreferences(aCRAConfiguration.sharedPreferencesName(), aCRAConfiguration.sharedPreferencesMode());
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)mApplication);
    }

    public static ACRAConfiguration getConfig() {
        if (configProxy == null) {
            if (mApplication == null) {
                log.w(LOG_TAG, "Calling ACRA.getConfig() before ACRA.init() gives you an empty configuration instance. You might prefer calling ACRA.getNewDefaultConfig(Application) to get an instance with default values taken from a @ReportsCrashes annotation.");
            }
            configProxy = ACRA.getNewDefaultConfig(mAnnotationProxy);
        }
        return configProxy;
    }

    public static void setConfig(ACRAConfiguration aCRAConfiguration) {
        configProxy = aCRAConfiguration;
    }

    public static ACRAConfiguration getNewDefaultConfig(AnnotationProxy annotationProxy) {
        if (annotationProxy != null) {
            return new ACRAConfiguration(annotationProxy.getClass().getAnnotation(ReportsCrashes.class));
        }
        return new ACRAConfiguration(null);
    }

    static boolean isDebuggable() {
        PackageManager packageManager = mApplication.getPackageManager();
        try {
            return (packageManager.getApplicationInfo((String)ACRA.mApplication.getPackageName(), (int)0).flags & 2) > 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static Application getApplication() {
        return mApplication;
    }

    public static void setLog(ACRALog aCRALog) {
        log = aCRALog;
    }
}

