﻿using System;
using System.IO;
using System.Reflection;
using System.Text;
using System.Windows;
using System.Diagnostics;
using System.Windows.Controls;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Input;
using Zeta.Common;
using Zeta.Game;
using Zeta.Game.Internals.Actors;
using Zeta.Common.Xml;
using Zeta.XmlEngine;

namespace VaultRunner
{
    public class GreedWindow
    {
        private static Window _greedWindow;

        private static UserControl _mainControl;

        private static readonly string _content =
        @"<UserControl xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation'
             xmlns:x='http://schemas.microsoft.com/winfx/2006/xaml'
             xmlns:mc='http://schemas.openxmlformats.org/markup-compatibility/2006' 
             xmlns:d='http://schemas.microsoft.com/expression/blend/2008'
             xmlns:sys='clr-namespace:System;assembly=mscorlib'
             mc:Ignorable='d' 
             d:DesignHeight='450' d:DesignWidth='600' Foreground='{DynamicResource TextBrush}'>    
            <DockPanel Background='#333'>        
                <StackPanel HorizontalAlignment='Stretch' VerticalAlignment='Top'>
                    <StackPanel HorizontalAlignment='Center' VerticalAlignment='Center'>
                        <WrapPanel HorizontalAlignment='Left'>
                            <TextBlock Text='Enable Greeds Domain' Margin='0,0,10,0' HorizontalAlignment='Left' VerticalAlignment='Center' />                            
                            <CheckBox IsChecked='{Binding Path=GreedRealm}'  Margin='0' HorizontalAlignment='Left' VerticalAlignment='Center' />
                        </WrapPanel>
                        <WrapPanel HorizontalAlignment='Left'>
                            <TextBlock Text='Enable Whimsydale' Margin='0,0,10,0' HorizontalAlignment='Left' VerticalAlignment='Center' />                            
                            <CheckBox IsChecked='{Binding Path=RainbowRealm}'  Margin='0' HorizontalAlignment='Left' VerticalAlignment='Center' />
                        </WrapPanel>
                  </StackPanel>
                </StackPanel>
            </DockPanel>
        </UserControl>";

        private static void CloseWindow()
        {
            _greedWindow.Close();
        }

        public static Window GetDisplay()
        {
            if (_greedWindow == null)
            {
                _greedWindow = new Window();
            }

            _greedWindow.DataContext = GreedSettings.Instance;

            if (_mainControl == null)
                _mainControl = (UserControl)XamlReader.Load(new MemoryStream(Encoding.UTF8.GetBytes(_content)));

            _greedWindow.Content = _mainControl;

            _greedWindow.Title = "Greeds Domain";
            _greedWindow.Width = 350;
            _greedWindow.Height = 200;
            _greedWindow.ResizeMode = ResizeMode.NoResize;
            _greedWindow.Background = Brushes.DarkGray;
            _greedWindow.WindowStartupLocation = WindowStartupLocation.CenterOwner;
            _greedWindow.Owner = Application.Current.MainWindow;

            _greedWindow.Closed += WindowClosed;
            Application.Current.Exit += WindowClosed;

            return _greedWindow;
        }

        private static void WindowClosed(object sender, EventArgs e)
        {
            GreedSettings.Instance.Save();
            if (_greedWindow != null)
            {
                Application.Current.Exit -= WindowClosed;
                _greedWindow.Closed -= WindowClosed;
                _greedWindow = null;
            }
        }
    }
}
