﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zeta.Common.Xml;
using Zeta.Game;
using Zeta.XmlEngine;

namespace VaultRunner
{
    [XmlElement("GreedSettings")]
    public class GreedSettings : XmlSettings
    {
        private static string _battleTagName;
        public static string BattleTagName
        {
            get
            {
                if (string.IsNullOrWhiteSpace(_battleTagName) && ZetaDia.Service.Hero.IsValid)
                    _battleTagName = ZetaDia.Service.Hero.BattleTagName;
                return _battleTagName;
            }
        }

        public GreedSettings() :
            base(Path.Combine(SettingsDirectory, BattleTagName, "VaultRunner", "Settings.xml"))
        {
        }

        private static GreedSettings _instance;
        public static GreedSettings Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new GreedSettings();

                    if (!_instance._rainbowRealm.HasValue)
                        _instance._rainbowRealm = false;

                    if (!_instance._greedRealm.HasValue)
                        _instance._greedRealm = true;
                }
                return _instance;
            }
        }

        private bool? _rainbowRealm;
        [XmlElement("RainbowRealm")]
        [DefaultValue(false)]
        [Setting]
        public bool RainbowRealm
        {
            get
            {
                return _rainbowRealm.Value;
            }
            set
            {
                if (_rainbowRealm.HasValue && _rainbowRealm.Value == value)
                    return;
                _rainbowRealm = (bool)value;
                OnPropertyChanged("RainbowRealm");
            }
        }

        private bool? _greedRealm;
        [XmlElement("GreedRealm")]
        [DefaultValue(true)]
        [Setting]
        public bool GreedRealm
        {
            get
            {
                return _greedRealm.Value;
            }
            set
            {
                if (_greedRealm.HasValue && _greedRealm.Value == value)
                    return;
                _greedRealm = (bool)value;
                OnPropertyChanged("GreedRealm");
            }
        }
    }
}
