var spawn = require('child_process').spawn;

const app = require('app');

const updater = require('./updater.js');
const main = require('./main.js');

require('crash-reporter').start();

function restart() {
    var argv = process.argv;

    var child = spawn(argv[0], argv.slice(1), {detached: true, stdio: 'ignore'});
    child.unref();
    app.quit()
}

function run() {
    var latestUpdateFile = updater.checkLocalUpdates();
    if (latestUpdateFile) {
        if (updater.installUpdate(latestUpdateFile)) {
            return restart()
        }
    }

    main();
    //console.log(app.getPath("appData"));
    //require('dialog').showErrorBox(app.getVersion(), APP_DIR);
    updater.setFeedUrl(`http://ppduck.com/update/feed?ver=${app.getVersion()}`);
    updater.checkRemoteUpdates(60 * 1000);
}

run();

