/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.utils;

import com.zsword.modules.utils.BitsUtil;
import com.zsword.utils.MemoryOptLibNative;

public class ProcessMemoryUtils {
    public static void setLibPath(String path) {
        System.setProperty("MemoryOptLib", path);
    }

    public static int openProcess(String procesName, String exeFileName) {
        return MemoryOptLibNative.openProcess(procesName, exeFileName, 0);
    }

    public static byte[] readProcessMemory(int handle, int address, int count) {
        return MemoryOptLibNative.readProcessMemory(handle, address, count);
    }

    public static int readMemoryInt(int handle, int address) {
        byte[] data = ProcessMemoryUtils.readProcessMemory(handle, address, 4);
        return BitsUtil.getInt(data, false);
    }

    public static long readMemoryLong(int handle, int address) {
        byte[] data = ProcessMemoryUtils.readProcessMemory(handle, address, 8);
        return BitsUtil.getLong(data, false);
    }

    public static float readProcessMemoryAsFloat(int handle, int address) {
        byte[] res = ProcessMemoryUtils.readProcessMemory(handle, address, 4);
        float rs = BitsUtil.getFloat(res, true);
        return rs;
    }

    public static int readProcessMemoryAsInt(int handle, int address, int count) {
        byte[] res = ProcessMemoryUtils.readProcessMemory(handle, address, count);
        int rs = BitsUtil.getInt(res, true);
        return rs;
    }

    public static int readProcessMemoryAsIntAll(int handle, int address) {
        return ProcessMemoryUtils.readProcessMemoryAsInt(handle, address, 4);
    }

    public static int writeProcessMemory(int handle, int address, byte[] data, int count) {
        return MemoryOptLibNative.writeProcessMemory(handle, address, data, count);
    }

    public static int writeProcessMemoryAll(int handle, int address, byte[] data) {
        return ProcessMemoryUtils.writeProcessMemory(handle, address, data, data.length);
    }

    public static int writeProcessMemoryNativeWithInt(int handle, int address, int data, int count) {
        return MemoryOptLibNative.writeProcessMemoryWithInt(handle, address, data, count);
    }

    public static int writeProcessMemoryNativeWithIntAll(int handle, int address, int data) {
        return ProcessMemoryUtils.writeProcessMemoryNativeWithInt(handle, address, data, 4);
    }

    public static int writeProcessMemoryNativeWithLong(int handle, int address, long data, int count) {
        return MemoryOptLibNative.writeProcessMemoryWithLong(handle, address, data, count);
    }

    public static int writeProcessMemoryNativeWithLongAll(int handle, int address, long data) {
        return ProcessMemoryUtils.writeProcessMemoryNativeWithLong(handle, address, data, 8);
    }

    public static int writeProcessMemoryNativeWithFloat(int handle, int address, float data, int count) {
        return MemoryOptLibNative.writeProcessMemoryWithFloat(handle, address, data, count);
    }

    public static int writeProcessMemoryNativeWithFloatAll(int handle, int address, float data) {
        return ProcessMemoryUtils.writeProcessMemoryNativeWithFloat(handle, address, data, 4);
    }

    public static int writeProcessMemoryWithInt(int handle, int address, int source, int count) {
        byte[] res = BitsUtil.intToBytes(source);
        return MemoryOptLibNative.writeProcessMemory(handle, address, res, count);
    }

    public static int writeProcessMemoryWithFloat(int handle, int address, float source, int count) {
        byte[] res = BitsUtil.floatToBytes(source);
        return MemoryOptLibNative.writeProcessMemory(handle, address, res, count);
    }

    public static int closeHandle(int handle) {
        return MemoryOptLibNative.closeHandle(handle);
    }

    public static enum CharSet {
        UTF8(0),
        GBK(1);

        private int value;

        private CharSet(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

