/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.zip;

import com.zsword.modules.io.DataFileInputStream;
import com.zsword.modules.zip.LZMADataHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.IOUtils;

public abstract class ZipDataUtil {
    private static final int BUFFER_SIZE = 0x100000;

    public static List<String> listAllName(RandomAccessFile file, boolean autoClose) throws IOException {
        ZipArchiveInputStream zipin = new ZipArchiveInputStream((InputStream)new DataFileInputStream(file));
        try {
            ArrayList<String> nameList = new ArrayList<String>();
            ZipArchiveEntry entry = null;
            while ((entry = zipin.getNextZipEntry()) != null) {
                nameList.add(entry.getName());
            }
            ArrayList<String> arrayList = nameList;
            return arrayList;
        }
        finally {
            if (autoClose) {
                IOUtils.closeQuietly((Closeable)zipin);
            }
        }
    }

    public static List<ZipEntry> listAll(File file) throws IOException {
        RandomAccessFile dataIn = new RandomAccessFile(file, "r");
        try {
            List<ZipEntry> list = ZipDataUtil.listAll(dataIn, true);
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)dataIn);
        }
    }

    public static List<ZipEntry> listAll(RandomAccessFile file, boolean autoClose) throws IOException {
        ZipArchiveInputStream zipin = new ZipArchiveInputStream((InputStream)new DataFileInputStream(file));
        try {
            ArrayList<ZipEntry> entryList = new ArrayList<ZipEntry>();
            ZipArchiveEntry entry = null;
            while ((entry = zipin.getNextZipEntry()) != null) {
                entryList.add((ZipEntry)entry);
            }
            ArrayList<ZipEntry> arrayList = entryList;
            return arrayList;
        }
        finally {
            if (autoClose) {
                IOUtils.closeQuietly((Closeable)zipin);
            }
        }
    }

    public static List<File> extraAll(File file, File outDir) throws IOException {
        return ZipDataUtil.extraAll(file, outDir, null);
    }

    public static List<File> extraAll(File file, File outDir, String regexpFilter) throws IOException {
        RandomAccessFile fileIn = new RandomAccessFile(file, "r");
        return ZipDataUtil.extraAll(fileIn, outDir, regexpFilter);
    }

    public static List<File> extraAll(RandomAccessFile file, File outDir, String regexpFilter) throws IOException {
        ZipArchiveInputStream zipin = new ZipArchiveInputStream((InputStream)new DataFileInputStream(file));
        try {
            List<File> list = ZipDataUtil.extraAll(zipin, file, outDir, regexpFilter);
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)zipin);
        }
    }

    public static List<File> extraAll(ZipArchiveInputStream zipin, RandomAccessFile file, File outDir, String regexpFilter) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ZipArchiveEntry entry = null;
        while ((entry = zipin.getNextZipEntry()) != null) {
            String entryName = entry.getName();
            if (regexpFilter != null && !regexpFilter.isEmpty() && !entryName.matches(regexpFilter)) continue;
            System.out.println(entryName);
            File outFile = new File(outDir, entryName);
            FileOutputStream output = new FileOutputStream(outFile);
            try {
                ZipDataUtil.extraEntry(zipin, (ZipEntry)entry, file, output);
                output.close();
                files.add(outFile);
            }
            finally {
                IOUtils.closeQuietly((Closeable)output);
            }
        }
        return files;
    }

    public static File extraEntry(RandomAccessFile file, String name, File outFile) throws IOException {
        FileOutputStream output = new FileOutputStream(outFile);
        try {
            ZipDataUtil.extraEntry(file, name, output);
            File file2 = outFile;
            return file2;
        }
        finally {
            IOUtils.closeQuietly((Closeable)output);
        }
    }

    public static void extraEntry(RandomAccessFile file, String name, OutputStream output) throws IOException {
        ZipArchiveInputStream zipin = new ZipArchiveInputStream((InputStream)new DataFileInputStream(file));
        try {
            ZipArchiveEntry entry = null;
            while ((entry = zipin.getNextZipEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.equals(name)) continue;
                ZipDataUtil.extraEntry(zipin, (ZipEntry)entry, file, output);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)zipin);
        }
    }

    private static void extraEntry(ZipArchiveInputStream zipin, ZipEntry entry, RandomAccessFile file, OutputStream output) throws IOException {
        long pos = file.getFilePointer();
        byte[] buffer = new byte[0x100000];
        int count = 0;
        int methodCode = entry.getMethod();
        ZipMethod method = ZipMethod.getMethodByCode((int)methodCode);
        switch (method) {
            case STORED: 
            case DEFLATED: {
                while ((count = zipin.read(buffer)) > 0) {
                    output.write(buffer, 0, count);
                }
                break;
            }
            case LZMA: {
                int flag = file.readInt();
                if (flag != 152438016) {
                    file.seek(pos);
                    LZMADataHelper.decodeLZMA(file, output);
                } else {
                    LZMADataHelper.decodeLZMA(file, entry.getSize(), output);
                }
                System.out.println("Is LZMA");
                break;
            }
            default: {
                throw new ZipException("Invalid Compression Method! " + methodCode);
            }
        }
        output.flush();
        file.seek(pos);
    }
}

