/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.zip;

import com.zsword.modules.io.ByteDataFile;
import com.zsword.modules.io.DataFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.tukaani.xz.LZMAInputStream;

class LZMADataHelper {
    private static final int BUFFER_SIZE = 0x100000;

    LZMADataHelper() {
    }

    static void decodeLZMA(RandomAccessFile file, OutputStream output) throws IOException {
        byte propsByte = file.readByte();
        int dictSize = ByteDataFile.readBytesAsInt(file, 4);
        long uncompSize = ByteDataFile.readBytesAsLong(file, 8);
        LZMADataHelper.decodeLZMA(file, propsByte, dictSize, uncompSize, output);
    }

    static void decodeLZMA(RandomAccessFile file, long uncompSize, OutputStream output) throws IOException {
        byte propsByte = file.readByte();
        int dictSize = ByteDataFile.readBytesAsInt(file, 4);
        LZMADataHelper.decodeLZMA(file, propsByte, dictSize, uncompSize, output);
    }

    static void decodeLZMA(RandomAccessFile file, byte propsByte, int dictSize, long uncompSize, OutputStream output) throws IOException {
        DataFileInputStream dataIn = new DataFileInputStream(file);
        System.out.printf("UncompSize:%#x, PropsByte:%#x, DictSize:%#x\n", uncompSize, propsByte, dictSize);
        LZMAInputStream lzmaIn = new LZMAInputStream((InputStream)dataIn, uncompSize, propsByte, dictSize);
        int count = 0;
        byte[] buffer = new byte[0x100000];
        while ((count = lzmaIn.read(buffer)) > 0) {
            output.write(buffer, 0, count);
        }
        output.flush();
    }
}

