/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.utils;

import com.zsword.modules.utils.BitsUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class BufferUtil {
    public static IntBuffer allocateIntBufferDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).asIntBuffer();
    }

    public static FloatBuffer allocateFloatBufferDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).asFloatBuffer();
    }

    public static float readFloat(ByteBuffer io) {
        int temp = BufferUtil.readBytesAsInt(io, 4);
        return Float.intBitsToFloat(temp);
    }

    public static float readBytesAsFloat(ByteBuffer io, int len) {
        int temp = BufferUtil.readBytesAsInt(io, len);
        return Float.intBitsToFloat(temp);
    }

    public static int readBytesAsInt(ByteBuffer io, int len) {
        return BufferUtil.readBytesAsInt(io, len, false);
    }

    public static short readBytesAsShort(ByteBuffer io, int len) {
        return BufferUtil.readBytesAsShort(io, len, false);
    }

    protected static short readBytesAsShort(ByteBuffer io, int len, boolean bigEndin) {
        byte[] buf = new byte[len];
        io.get(buf);
        return BitsUtil.getShort(buf, bigEndin);
    }

    protected static int readBytesAsInt(ByteBuffer io, int len, boolean bigEndin) {
        byte[] buf = new byte[len];
        io.get(buf);
        return BitsUtil.getInt(buf, bigEndin);
    }

    public static long readBytesAsLong(ByteBuffer io, int len) {
        return BufferUtil.readBytesAsLong(io, len, false);
    }

    protected static long readBytesAsLong(ByteBuffer io, int len, boolean bigEndin) {
        byte[] buf = new byte[len];
        io.get(buf);
        return BitsUtil.getLong(buf, bigEndin);
    }
}

