/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.utils;

public class BitsUtil {
    private BitsUtil() {
    }

    static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    static int swap(int x) {
        return BitsUtil.swap((short)x) << 16 | BitsUtil.swap((short)(x >> 16)) & 0xFFFF;
    }

    static long swap(long x) {
        return (long)BitsUtil.swap((int)x) << 32 | (long)BitsUtil.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static byte[] intToBytes(int source) {
        source = Integer.reverseBytes(source);
        byte[] buffer = new byte[4];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = (byte)(source >> 24 - i * 8);
            ++i;
        }
        return buffer;
    }

    public static byte[] floatToBytes(float source) {
        int rs = Float.floatToIntBits(source);
        rs = Integer.reverseBytes(rs);
        byte[] buffer = new byte[4];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = (byte)(rs >> 24 - i * 8);
            ++i;
        }
        return buffer;
    }

    private static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    private static byte char1(char x) {
        return (byte)(x >> 8);
    }

    private static byte char0(char x) {
        return (byte)(x >> 0);
    }

    public static short getShort(byte[] src, boolean bigEndin) {
        short result = BitsUtil.makeShort(src[1], src[0]);
        if (bigEndin) {
            result = BitsUtil.swap(result);
        }
        return result;
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)(x >> 0);
    }

    public static int getInt(byte[] src, boolean bigEndin) {
        byte[] temp = new byte[4];
        int i = 0;
        while (i < src.length) {
            if (i > 3) break;
            temp[i] = src[i];
            ++i;
        }
        if (!bigEndin) {
            return BitsUtil.makeInt(temp[3], temp[2], temp[1], temp[0]);
        }
        return BitsUtil.makeInt(temp[0], temp[1], temp[2], temp[3]);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)(x >> 0);
    }

    public static float getFloat(byte[] src, boolean bigEndin) {
        int res = BitsUtil.getInt(src, bigEndin);
        float rs = Float.intBitsToFloat(res);
        return rs;
    }

    public static long getLong(byte[] src, boolean bigEndin) {
        byte[] temp = new byte[8];
        int i = 0;
        while (i < src.length) {
            if (i > 7) break;
            temp[i] = src[i];
            ++i;
        }
        if (!bigEndin) {
            return BitsUtil.makeLong(temp[7], temp[6], temp[5], temp[4], temp[3], temp[2], temp[1], temp[0]);
        }
        return BitsUtil.makeLong(temp[4], temp[5], temp[6], temp[7], temp[0], temp[1], temp[2], temp[3]);
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    public static byte[] getBytes(int value, boolean bigEndian) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < bytes.length) {
            if (bigEndian) {
                bytes[i] = (byte)(value >> i * 8);
            } else {
                bytes[bytes.length - 1 - i] = (byte)(value >> i * 8);
            }
            ++i;
        }
        return bytes;
    }

    public static byte[] getLongBytes(long value, boolean bigEndian) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            if (bigEndian) {
                bytes[i] = (byte)(value >> i * 8);
            } else {
                bytes[bytes.length - 1 - i] = (byte)(value >> i * 8);
            }
            ++i;
        }
        return bytes;
    }

    public static String getHexString(byte[] data) {
        return BitsUtil.getHexString(data, 0, data.length);
    }

    public static String getHexString(byte[] data, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        int i = start;
        while (i < end) {
            int b = data[i] & 0xFF;
            buffer.append(String.format("%X ", b));
            ++i;
        }
        return buffer.toString();
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)(x >> 0);
    }
}

