/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing.table;

import com.zsword.modules.event.CellEditingEvent;
import com.zsword.modules.event.CellEditingListener;
import com.zsword.modules.swing.ComponentCellEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ConfigurableTable
extends JTable {
    private EventListenerList cellEditingListeners = new EventListenerList();
    private Map<String, Map<String, Object>> config;
    private List<Integer> editableColumns;

    public ConfigurableTable(Map<String, Map<String, Object>> config) {
        super(new Vector(), ConfigurableTable.buildColumnNames(config.keySet()));
        this.config = config;
        this.initItems();
    }

    private static Vector<String> buildColumnNames(Collection<String> list) {
        Vector<String> vec = new Vector<String>();
        if (!list.contains("no")) {
            vec.add("no");
        }
        vec.addAll(list);
        return vec;
    }

    protected void initItems() {
        this.editableColumns = new ArrayList<Integer>();
        TableColumnModel colModel = this.getColumnModel();
        int i = 0;
        while (i < this.getColumnCount()) {
            TableColumn column = colModel.getColumn(i);
            String key = this.getColumnName(i);
            Map<String, Object> obj = this.config.get(key);
            if (obj == null) {
                if ("no".equals(key)) {
                    column.setHeaderValue("\u5e8f\u53f7");
                    column.setPreferredWidth(20);
                }
            } else {
                String renderer;
                String type;
                Integer len = (Integer)obj.get("length");
                column.setIdentifier(key);
                String name = (String)obj.get("label");
                name = name == null ? key : name;
                column.setHeaderValue(name);
                Integer width = (Integer)obj.get("width");
                if (width != null) {
                    column.setPreferredWidth(width);
                }
                String hidden = String.valueOf(obj.get("hidden"));
                if (Boolean.TRUE.toString().equals(hidden)) {
                    column.setMinWidth(0);
                    column.setMaxWidth(0);
                    column.setResizable(false);
                }
                String editable = String.valueOf(obj.get("editable"));
                if (Boolean.TRUE.toString().equalsIgnoreCase(editable)) {
                    this.editableColumns.add(i);
                }
                if ((type = (String)obj.get("type")) != null && "int".equalsIgnoreCase(type)) {
                    Integer maxVal = (Integer)obj.get("max");
                    maxVal = maxVal == null ? Integer.MAX_VALUE : maxVal;
                    Integer minVal = (Integer)obj.get("min");
                    minVal = minVal == null ? Integer.MIN_VALUE : minVal;
                    SpinnerNumberModel spinnerModel = new SpinnerNumberModel(minVal > 0 ? minVal : 0, minVal, maxVal, 1);
                    JSpinner spinner = new JSpinner(spinnerModel);
                    column.setCellEditor(new ComponentCellEditor(spinner));
                }
                if ((renderer = (String)obj.get("renderer")) != null && "hex".equalsIgnoreCase(renderer)) {
                    String format = (String)obj.get("format");
                    if (format == null && len != null) {
                        format = "%0" + len * 2 + 'X';
                    }
                    column.setCellRenderer(new HexCellRender(format));
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editableColumns.contains(column);
    }

    @Override
    public void editingStopped(ChangeEvent evt) {
        CellEditingListener[] listeners;
        int row = this.editingRow;
        int col = this.editingColumn;
        Object oldValue = this.getValueAt(row, col);
        super.editingStopped(evt);
        Object newValue = this.getValueAt(row, col);
        if (!String.valueOf(newValue).equals(String.valueOf(oldValue)) && (listeners = (CellEditingListener[])this.cellEditingListeners.getListeners(CellEditingListener.class)).length > 0) {
            CellEditingEvent newEvt = new CellEditingEvent(evt.getSource(), row, col, oldValue, newValue);
            CellEditingListener[] cellEditingListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditingListener l = cellEditingListenerArray[n2];
                l.valueChanged(newEvt);
                ++n2;
            }
        }
    }

    public void addCellEditingListener(CellEditingListener l) {
        this.cellEditingListeners.add(CellEditingListener.class, l);
    }

    private class HexCellRender
    extends DefaultTableCellRenderer {
        private String format;

        public HexCellRender(String format) {
            this.format = format == null ? "%#X" : format;
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Number) {
                value = String.format(this.format, value);
            }
            super.setValue(value);
        }
    }
}

