/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class BeanMapTableModel
extends DefaultTableModel {
    protected Vector<Map<String, Object>> mapValues = null;
    protected Map<String, Map<String, Object>> columnInfo = null;

    public BeanMapTableModel() {
        this(new ArrayList<Map<String, Object>>());
    }

    public BeanMapTableModel(Map<String, Map<String, Object>> columnInfo) {
        this(new ArrayList<Map<String, Object>>(), columnInfo);
    }

    public BeanMapTableModel(Collection<Map<String, Object>> values) {
        this(values, new HashMap<String, Map<String, Object>>());
    }

    public BeanMapTableModel(Collection<Map<String, Object>> values, Map<String, Map<String, Object>> columnInfo) {
        super(new Vector(), BeanMapTableModel.buildColumnNames(columnInfo.keySet()));
        this.initDataVector(values);
        this.columnInfo = columnInfo;
    }

    private static Vector<String> buildColumnNames(Collection<String> list) {
        Vector<String> vec = new Vector<String>();
        if (!list.contains("no")) {
            vec.add("no");
        }
        vec.addAll(list);
        return vec;
    }

    protected void initDataVector(Collection<Map<String, Object>> values) {
        this.mapValues = new Vector();
        for (Map<String, Object> data : values) {
            this.mapValues.add(data);
        }
        this.dataVector = this.mapValues;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        String key = this.getColumnName(col);
        Map<String, Object> info = this.columnInfo.get(key);
        if (info != null) {
            return Boolean.TRUE.equals(info.get("editable"));
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String key = this.getColumnName(col);
        Map<String, Object> rowData = this.mapValues.get(row);
        Object val = rowData.get(key);
        if ("no".equals(key) && val == null) {
            return row + 1;
        }
        return val;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Map<String, Object> rowData = this.mapValues.elementAt(row);
        String key = this.getColumnName(col);
        rowData.put(key, value);
        super.fireTableRowsUpdated(row, row);
    }

    @Override
    public void setRowCount(int rowCount) {
        super.setRowCount(rowCount);
    }
}

