/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1116424058223480751L;
    private JProgressBar progressBar;
    private JLabel label;

    public static void main(String[] args) {
        try {
            JFrame mainFrame = new JFrame();
            mainFrame.setDefaultCloseOperation(3);
            mainFrame.setSize(new Dimension(640, 480));
            ProgressDialog frame = new ProgressDialog(null);
            mainFrame.setVisible(true);
            int i = 0;
            while (i < 11) {
                frame.changeValue(i * 10);
                Thread.sleep(1000L);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ProgressDialog(Container ownere) {
        this.initComponents();
        this.setTitle("Progress...");
    }

    public void changeValue(float value) {
        int progress;
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (value >= 100.0f) {
            this.dispose();
        }
        if (Math.abs((progress = (int)(value * 10.0f)) - this.progressBar.getValue()) < 5) {
            return;
        }
        this.progressBar.setValue(progress);
        String desc = String.valueOf(String.format("Completed\uff1a%10.1f", Float.valueOf(value))) + '%';
        this.progressBar.setString(desc);
        this.label.setText(desc);
        this.update(this.getGraphics());
    }

    private void initComponents() {
        this.setSize(250, 100);
        this.setResizable(false);
        this.setTitle("Progress:");
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        Container contentPane = this.getContentPane();
        this.label = new JLabel(" ", 0);
        this.label.setForeground(Color.blue);
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.progressBar.setOrientation(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setDoubleBuffered(true);
        contentPane.add((Component)this.progressBar, "Center");
        contentPane.add((Component)this.label, "South");
        this.pack();
    }
}

