/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;

public abstract class PanelBase
extends JPanel
implements ActionListener {
    protected boolean isValueEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)obj.toString());
    }

    protected void showMessage(String msg, String title, int type) {
        JOptionPane.showMessageDialog(this, msg, title, type);
    }

    protected void showMessage(String msg, int type) {
        this.showMessage(msg, null, type);
    }

    protected void showMessage(String msg) {
        this.showMessage(msg, 1);
    }

    protected void handleError(Exception e, String msg) {
        e.printStackTrace();
        this.showMessage(String.valueOf(msg) + e.getMessage(), "\u51fa\u9519\u4e86!", 0);
    }

    protected File showOpenFileDialog(String workDir, String comment, String ... filters) {
        JFileChooser chooser = new JFileChooser(workDir);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileNameExtensionFilter(comment, filters));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected File showSaveFileDialog(String workDir, String comment, String ... filters) {
        JFileChooser chooser = new JFileChooser(workDir);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileNameExtensionFilter(comment, filters));
        if (chooser.showSaveDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

