/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing;

import com.zsword.modules.swing.fileio.RegexpFileFilter;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

public abstract class FrameBase
extends JFrame
implements ActionListener {
    protected boolean isValueEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)obj.toString());
    }

    protected void showMessage(String msg, String title, int type) {
        JOptionPane.showMessageDialog(this, msg, title, type);
    }

    protected void showMessage(String msg, int type) {
        this.showMessage(msg, null, type);
    }

    protected void showMessage(String msg) {
        this.showMessage(msg, 1);
    }

    protected void handleError(Exception e, String msg) {
        e.printStackTrace();
        this.showMessage(String.valueOf(msg) + e.getMessage(), "\u51fa\u9519\u4e86!", 0);
    }

    protected void center() {
        Dimension winSize = this.getToolkit().getScreenSize();
        this.setLocation((winSize.width - this.getWidth()) / 2, (winSize.height - this.getHeight()) / 2);
    }

    protected File showOpenFileDialog(String workDir) {
        JFileChooser chooser = new JFileChooser(workDir);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected File showOpenFileDialog(String workDir, String expression, String description) {
        JFileChooser chooser = new JFileChooser(workDir);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new RegexpFileFilter(expression, description));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected File showOpenFileDialog(String workDir, String expression) {
        return this.showOpenFileDialog(workDir, expression, null);
    }

    protected File showSaveFileDialog(String workDir) {
        JFileChooser chooser = new JFileChooser(workDir);
        if (chooser.showSaveDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

