/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;

public class ComponentCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected EditorType editorType;
    protected JComponent editorField;
    protected CellEditorDelegate delegate;
    protected int clickCountToStart = 1;

    public ComponentCellEditor(JComponent comp) {
        this.editorField = comp;
        this.clickCountToStart = 2;
        this.delegate = new CellEditorDelegate(this){

            @Override
            public void setValue(Object value) {
                this.setEditorValue(value);
            }

            @Override
            public Object getCellEditorValue() {
                return this.getEditorValue();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return this.shouldEditorSelectCell(anEvent);
            }

            @Override
            public boolean stopCellEditing() {
                this.stopEditorCellEditing();
                return super.stopCellEditing();
            }
        };
        Class<?> type = comp.getClass();
        if (JTextField.class.isAssignableFrom(type)) {
            this.editorType = EditorType.Text;
            ((JTextField)comp).addActionListener(this.delegate);
        } else if (AbstractButton.class.isAssignableFrom(type)) {
            this.editorType = EditorType.Button;
            if (JCheckBox.class.isAssignableFrom(type)) {
                this.editorType = EditorType.CheckBox;
                ((JCheckBox)comp).setRequestFocusEnabled(false);
            }
            ((AbstractButton)comp).addActionListener(this.delegate);
        } else if (JComboBox.class.isAssignableFrom(type)) {
            this.editorType = EditorType.ComboBox;
            ((JComboBox)comp).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            ((JComboBox)comp).addActionListener(this.delegate);
        } else if (JSpinner.class.isAssignableFrom(type)) {
            this.editorType = EditorType.Spinner;
            ((JSpinner)comp).addChangeListener(this.delegate);
        } else if (JList.class.isAssignableFrom(type)) {
            this.editorType = EditorType.List;
            ((JList)comp).addListSelectionListener(this.delegate);
        }
    }

    protected void setEditorValue(Object value) {
        switch (this.editorType) {
            case CheckBox: {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                ((JCheckBox)this.editorField).setSelected(selected);
                break;
            }
            case ComboBox: {
                ((JComboBox)this.editorField).setSelectedItem(value);
                break;
            }
            case Spinner: {
                ((JSpinner)this.editorField).setValue(value);
                break;
            }
            case Text: {
                ((JTextField)this.editorField).setText(value != null ? value.toString() : "");
                break;
            }
        }
    }

    protected Object getEditorValue() {
        switch (this.editorType) {
            case CheckBox: {
                return ((JCheckBox)this.editorField).isSelected();
            }
            case ComboBox: {
                return ((JComboBox)this.editorField).getSelectedItem();
            }
            case Spinner: {
                return ((JSpinner)this.editorField).getValue();
            }
            case Text: {
                return ((JTextField)this.editorField).getText();
            }
        }
        return null;
    }

    protected boolean shouldEditorSelectCell(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)anEvent;
            return e.getID() != 506;
        }
        return true;
    }

    protected boolean stopEditorCellEditing() {
        switch (this.editorType) {
            case ComboBox: {
                if (!((JComboBox)this.editorField).isEditable()) break;
                ((JComboBox)this.editorField).actionPerformed(new ActionEvent(this, 0, ""));
                break;
            }
        }
        return true;
    }

    public Component getComponent() {
        return this.editorField;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.delegate.setValue(stringValue);
        return this.editorField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        if (this.editorField instanceof JCheckBox) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component c = renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            if (c != null) {
                this.editorField.setOpaque(true);
                this.editorField.setBackground(c.getBackground());
                if (c instanceof JComponent) {
                    this.editorField.setBorder(((JComponent)c).getBorder());
                }
            } else {
                this.editorField.setOpaque(false);
            }
        }
        return this.editorField;
    }

    protected class CellEditorDelegate
    implements ActionListener,
    ItemListener,
    ChangeListener,
    ListSelectionListener,
    Serializable {
        protected Object value;

        protected CellEditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= ComponentCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            ComponentCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            ComponentCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComponentCellEditor.this.stopCellEditing();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    static enum EditorType {
        Text,
        ComboBox,
        Button,
        CheckBox,
        Spinner,
        List;

    }
}

