/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.io;

import com.zsword.modules.utils.BitsUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class ByteDataFile
extends RandomAccessFile {
    private static final int BUFFER_SIZE = 0x100000;
    private long start;
    private long length;

    public String readBytesAsString(int num) throws IOException {
        byte[] buffer = new byte[num];
        this.read(buffer);
        return new String(buffer).trim();
    }

    public String readBytesAsString(int num, String encoding, boolean swap) throws IOException {
        byte[] buffer = new byte[num];
        this.read(buffer);
        if (swap) {
            int idx = -1;
            int i = 0;
            while (i < buffer.length / 2) {
                idx = i * 2;
                byte tmp = buffer[idx];
                buffer[idx] = buffer[idx + 1];
                buffer[idx + 1] = tmp;
                ++i;
            }
        }
        return new String(buffer, encoding).trim();
    }

    public float read4BytesAsFloat() throws IOException {
        int temp = this.read4BytesAsInt();
        return Float.intBitsToFloat(temp);
    }

    public long read4Bytes() throws IOException {
        return this.readBytesAsLong(4, false);
    }

    public int read4BytesAsInt() throws IOException {
        return this.readBytesAsInt(4, false);
    }

    public int readBytesAsInt(int num, boolean bigEndin) throws IOException {
        byte[] src = new byte[num];
        this.read(src);
        return BitsUtil.getInt(src, bigEndin);
    }

    public int readBytesAsInt(int num) throws IOException {
        return this.readBytesAsInt(num, false);
    }

    public long readBytesAsLong(int num) throws IOException {
        return this.readBytesAsLong(num, false);
    }

    public long readBytesAsLong(int num, boolean bigEndin) throws IOException {
        byte[] src = new byte[num];
        this.read(src);
        return BitsUtil.getLong(src, bigEndin);
    }

    public static int readBytesAsInt(RandomAccessFile file, int num) throws IOException {
        return ByteDataFile.readBytesAsInt(file, num, false);
    }

    public static int readBytesAsInt(RandomAccessFile file, int num, boolean bigEndin) throws IOException {
        byte[] src = new byte[num];
        file.read(src);
        return BitsUtil.getInt(src, bigEndin);
    }

    public static long readBytesAsLong(RandomAccessFile file, int num) throws IOException {
        return ByteDataFile.readBytesAsLong(file, num, false);
    }

    public static long readBytesAsLong(RandomAccessFile file, int num, boolean bigEndin) throws IOException {
        byte[] src = new byte[num];
        file.read(src);
        return BitsUtil.getLong(src, bigEndin);
    }

    public void writeFloatBigEndin(float src) throws IOException {
        int temp = Float.floatToIntBits(src);
        this.writeIntBigEndin(temp);
    }

    public void writeIntBigEndin(int src) throws IOException {
        this.write(src >>> 0 & 0xFF);
        this.write(src >>> 8 & 0xFF);
        this.write(src >>> 16 & 0xFF);
        this.write(src >>> 24 & 0xFF);
    }

    public void writeShortBigEndin(int src) throws IOException {
        this.write(src >>> 0 & 0xFF);
        this.write(src >>> 8 & 0xFF);
    }

    public void writeInt(int src, int len) throws IOException {
        byte[] buff = BitsUtil.intToBytes(src);
        this.write(buff, 0, len);
    }

    public int writeString(String str, String encoding, boolean swap) throws IOException {
        byte[] buff = str.getBytes(encoding);
        if (swap) {
            buff = Arrays.copyOfRange(buff, 2, buff.length);
            int idx = -1;
            int i = 0;
            while (i < buff.length / 2) {
                idx = i * 2;
                byte tmp = buff[idx];
                buff[idx] = buff[idx + 1];
                buff[idx + 1] = tmp;
                ++i;
            }
        }
        this.write(buff);
        return buff.length;
    }

    public ByteDataFile(File file) throws FileNotFoundException {
        this(file, "r");
    }

    public ByteDataFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    public ByteDataFile(String name, String mode) throws FileNotFoundException {
        super(name, mode);
    }

    public ByteDataFile(File file, String mode, long start, long length) throws FileNotFoundException {
        super(file, mode);
        this.start = start;
        this.length = length;
    }

    public void setStart(long start) throws IOException {
        this.start = 0L;
        this.seek(start);
        this.start = start;
        this.length = super.length() - start;
    }

    public void setRange(long start, long length) throws IOException {
        this.setStart(start);
        this.length = length;
    }

    @Override
    public long getFilePointer() throws IOException {
        long addr = super.getFilePointer();
        return this.start > 0L ? addr - this.start : addr;
    }

    @Override
    public void seek(long pos) throws IOException {
        pos = this.start > 0L ? this.start + pos : pos;
        super.seek(pos);
    }

    @Override
    public long length() throws IOException {
        if (this.length > 0L) {
            return this.length;
        }
        return super.length();
    }

    public File writeToFile(File destFile, long start, long size) throws IOException {
        int bufferSize = (int)(size > 0x100000L ? 0x100000L : size);
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            this.seek(start);
            long rest = size;
            byte[] buffer = new byte[bufferSize];
            while (rest > 0L) {
                int len = (int)(rest > (long)bufferSize ? (long)bufferSize : rest);
                this.read(buffer, 0, len);
                ((BufferedOutputStream)out).write(buffer, 0, len);
                rest -= (long)len;
            }
            File file = destFile;
            return file;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

