/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.imageio;

import com.zsword.modules.io.ByteDataFile;
import com.zsword.modules.utils.BufferUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginDDS {
    private DDSHEADER header;
    private int bpp;
    private int rowBlockSize;
    private BufferedImage image;
    private static final Logger logger = Logger.getLogger(PluginDDS.class.getName());
    private static final int DDPF_ALPHAPIXELS = 1;
    private static final int DDPF_ALPHA = 2;
    private static final int DDPF_FOURCC = 4;
    private static final int DDPF_RGB = 64;
    private static final String FOURCC_DXT1 = "DXT1";
    private static final String FOURCC_DXT2 = "DXT2";
    private static final String FOURCC_DXT3 = "DXT3";
    private static final String FOURCC_DXT4 = "DXT4";
    private static final String FOURCC_DXT5 = "DXT5";
    private static final int FI_RGBA_RED = 2;
    private static final int FI_RGBA_GREEN = 1;
    private static final int FI_RGBA_BLUE = 0;
    private static final int FI_RGBA_ALPHA = 3;
    private static final int FI_RGBA_RED_MASK = 0xFF0000;
    private static final int FI_RGBA_GREEN_MASK = 65280;
    private static final int FI_RGBA_BLUE_MASK = 255;
    private static final int FI_RGBA_ALPHA_MASK = -16777216;
    private static final int FI_RGBA_RED_SHIFT = 16;
    private static final int FI_RGBA_GREEN_SHIFT = 8;
    private static final int FI_RGBA_BLUE_SHIFT = 0;
    private static final int FI_RGBA_ALPHA_SHIFT = 24;
    private static final int FIT_BITMAP = 1;

    static {
        logger.setLevel(Level.SEVERE);
    }

    public DDSHEADER getHeader() {
        return this.header;
    }

    public void setHeader(DDSHEADER header) {
        this.header = header;
    }

    public DDSHEADER createNewHeander() {
        return new DDSHEADER();
    }

    public BufferedImage readDDSFile(File ddsfile) throws IOException {
        ByteDataFile io = null;
        try {
            io = new ByteDataFile(ddsfile, "r");
            BufferedImage bufferedImage = this.readDDSFile(io);
            return bufferedImage;
        }
        finally {
            if (io != null) {
                io.close();
            }
        }
    }

    public BufferedImage readDDSFile(ByteDataFile io) throws IOException {
        this.readHeader(io);
        this.readPixeData(io);
        return this.image;
    }

    public BufferedImage convertToImage(ByteDataFile io) throws IOException {
        this.header.ddpfPixelFormat.dwFlags = 4;
        if (!(FOURCC_DXT1.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT2.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT4.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC))) {
            throw new IOException("Unkonw DDS Format");
        }
        this.readPixeData(io);
        return this.image;
    }

    public BufferedImage convertToImage(ByteBuffer io) throws IOException {
        this.header.ddpfPixelFormat.dwFlags = 4;
        if (!(FOURCC_DXT1.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT2.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT4.equals(this.header.ddpfPixelFormat.dwFourCC) || FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC))) {
            throw new IOException("Unkonw DDS Format");
        }
        this.readPixeData(io);
        return this.image;
    }

    public void readHeader(File ddsFile) throws IOException {
        ByteDataFile io = null;
        try {
            io = new ByteDataFile(ddsFile, "r");
            if (io == null || io.length() <= 0L) {
                return;
            }
            this.header = new DDSHEADER();
            byte[] buf = new byte[4];
            io.read(buf);
            this.header.dwMagic = new String(buf);
            this.header.dwSize = io.read4BytesAsInt();
            this.header.dwFlags = io.read4BytesAsInt();
            this.header.dwHeight = io.read4BytesAsInt();
            this.header.dwWidth = io.read4BytesAsInt();
            this.header.dwPitchOrLinearSize = io.read4BytesAsInt();
            this.header.dwDepth = io.read4BytesAsInt();
            this.header.dwMipMapCount = io.read4BytesAsInt();
            int i = 0;
            while (i < this.header.dwReserved1.length) {
                this.header.dwReserved1[i] = io.read4BytesAsInt();
                ++i;
            }
            this.header.ddpfPixelFormat.dwSize = io.read4BytesAsInt();
            this.header.ddpfPixelFormat.dwFlags = io.read4BytesAsInt();
            io.read(buf);
            this.header.ddpfPixelFormat.dwFourCC = new String(buf);
            this.header.ddpfPixelFormat.dwRGBBitCount = io.read4BytesAsInt();
            this.header.ddpfPixelFormat.dwRBitMask = io.read4BytesAsInt();
            this.header.ddpfPixelFormat.dwGBitMask = io.read4BytesAsInt();
            this.header.ddpfPixelFormat.dwBBitMask = io.read4BytesAsInt();
            this.header.ddpfPixelFormat.dwRGBAlphaBitMask = io.read4BytesAsInt();
            this.header.ddsCaps.dwCaps1 = io.read4BytesAsInt();
            this.header.ddsCaps.dwCaps2 = io.read4BytesAsInt();
            i = 0;
            while (i < this.header.ddsCaps.dwReserved.length) {
                this.header.ddsCaps.dwReserved[i] = io.read4BytesAsInt();
                ++i;
            }
            this.header.dwReserved2 = io.read4BytesAsInt();
            io.close();
        }
        finally {
            if (io != null) {
                io.close();
            }
        }
    }

    protected void readHeader(ByteDataFile io) throws IOException {
        if (io == null || io.length() <= 0L) {
            return;
        }
        this.header = new DDSHEADER();
        byte[] buf = new byte[4];
        io.read(buf);
        this.header.dwMagic = new String(buf);
        this.header.dwSize = io.read4BytesAsInt();
        this.header.dwFlags = io.read4BytesAsInt();
        this.header.dwHeight = io.read4BytesAsInt();
        this.header.dwWidth = io.read4BytesAsInt();
        this.header.dwPitchOrLinearSize = io.read4BytesAsInt();
        this.header.dwDepth = io.read4BytesAsInt();
        this.header.dwMipMapCount = io.read4BytesAsInt();
        int i = 0;
        while (i < this.header.dwReserved1.length) {
            this.header.dwReserved1[i] = io.read4BytesAsInt();
            ++i;
        }
        this.header.ddpfPixelFormat.dwSize = io.read4BytesAsInt();
        this.header.ddpfPixelFormat.dwFlags = io.read4BytesAsInt();
        io.read(buf);
        this.header.ddpfPixelFormat.dwFourCC = new String(buf);
        this.header.ddpfPixelFormat.dwRGBBitCount = io.read4BytesAsInt();
        this.header.ddpfPixelFormat.dwRBitMask = io.read4BytesAsInt();
        this.header.ddpfPixelFormat.dwGBitMask = io.read4BytesAsInt();
        this.header.ddpfPixelFormat.dwBBitMask = io.read4BytesAsInt();
        this.header.ddpfPixelFormat.dwRGBAlphaBitMask = io.read4BytesAsInt();
        this.header.ddsCaps.dwCaps1 = io.read4BytesAsInt();
        this.header.ddsCaps.dwCaps2 = io.read4BytesAsInt();
        i = 0;
        while (i < this.header.ddsCaps.dwReserved.length) {
            this.header.ddsCaps.dwReserved[i] = io.read4BytesAsInt();
            ++i;
        }
        this.header.dwReserved2 = io.read4BytesAsInt();
    }

    public static void writeHeader(ByteDataFile io, String pixelFormatStr, int width, int height, int mip) throws IOException {
        io.writeBytes("DDS ");
        io.writeInt(0x7C000000);
        io.writeInt(118491648);
        io.writeInt(Integer.reverseBytes(height));
        io.writeInt(Integer.reverseBytes(width));
        io.writeInt(Integer.reverseBytes(height * width));
        io.writeInt(0);
        io.writeInt(Integer.reverseBytes(mip));
        int i = 0;
        while (i < 11) {
            io.writeInt(0);
            ++i;
        }
        io.writeInt(0x20000000);
        io.writeInt(0x4000000);
        io.writeBytes(pixelFormatStr);
        int bitcount = 0;
        if (FOURCC_DXT3.equals(pixelFormatStr)) {
            bitcount = 256;
        } else if (FOURCC_DXT5.equals(pixelFormatStr)) {
            bitcount = 512;
        }
        io.writeInt(Integer.reverseBytes(bitcount));
        io.writeInt(0);
        io.writeInt(0);
        io.writeInt(0);
        io.writeInt(0);
        io.writeInt(135282688);
        io.writeInt(0);
        io.writeBytes("DDSX");
        io.writeInt(-1);
        io.writeInt(-1);
    }

    protected void readPixeData(ByteDataFile io) throws IOException {
        if (this.header == null) {
            throw new IOException("DDS Header is NULL");
        }
        this.image = new BufferedImage(this.header.dwWidth, this.header.dwHeight, 3);
        if ((this.header.ddpfPixelFormat.dwFlags & 0x40) != 0) {
            this.LoadRGB();
        } else if ((this.header.ddpfPixelFormat.dwFlags & 4) != 0) {
            this.LoadDXT(io);
        } else {
            throw new IOException("Unkown DDS Format");
        }
    }

    protected void readPixeData(ByteBuffer io) throws IOException {
        if (this.header == null) {
            throw new IOException("DDS Header is NULL");
        }
        this.image = new BufferedImage(this.header.dwWidth, this.header.dwHeight, 3);
        if ((this.header.ddpfPixelFormat.dwFlags & 0x40) != 0) {
            this.LoadRGB();
        } else if ((this.header.ddpfPixelFormat.dwFlags & 4) != 0) {
            this.LoadDXT(io);
        } else {
            throw new IOException("Unkown DDS Format");
        }
    }

    protected void LoadDXT(ByteDataFile io) throws IOException {
        if (this.header == null) {
            throw new IOException("DDS Header is NULL");
        }
        this.rowBlockSize = this.header.dwWidth * 4;
        int width = this.header.dwWidth & 0xFFFFFFFC;
        int height = this.header.dwHeight & 0xFFFFFFFC;
        int bytesPerBlock = 8;
        if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            bytesPerBlock = 16;
        } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            bytesPerBlock = 16;
        }
        this.bpp = 32;
        int line = (width * this.bpp + 7) / 8;
        int widthRest = width & 3;
        int heightRest = height & 3;
        int inputLine = (width + 3) / 4;
        ByteBuffer buff = ByteBuffer.allocate(inputLine * bytesPerBlock);
        if (height >= 4) {
            int yheight = 0;
            while (yheight < height) {
                buff.clear();
                io.read(buff.array());
                if (width >= 4) {
                    int xwidth = 0;
                    while (xwidth < width) {
                        this.DecodeDXTBlock(this.image, buff, xwidth, yheight, 4, 4);
                        xwidth += 4;
                    }
                }
                if (widthRest != 0) {
                    this.DecodeDXTBlock(this.image, buff, widthRest, yheight, widthRest, 4);
                }
                yheight += 4;
            }
        }
        if (heightRest != 0) {
            buff.clear();
            io.read(buff.array());
            if (width >= 4) {
                int xwidth = 0;
                while (xwidth < width) {
                    this.DecodeDXTBlock(this.image, buff, xwidth, heightRest, 4, heightRest);
                    xwidth += 4;
                }
            }
            if (widthRest != 0) {
                this.DecodeDXTBlock(this.image, buff, widthRest, heightRest, widthRest, heightRest);
            }
        }
    }

    protected void LoadDXT(ByteBuffer io) throws IOException {
        if (this.header == null) {
            throw new IOException("DDS Header is NULL");
        }
        this.rowBlockSize = this.header.dwWidth * 4;
        int width = this.header.dwWidth & 0xFFFFFFFC;
        int height = this.header.dwHeight & 0xFFFFFFFC;
        int bytesPerBlock = 8;
        if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            bytesPerBlock = 16;
        } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            bytesPerBlock = 16;
        }
        this.bpp = 32;
        int line = (width * this.bpp + 7) / 8;
        int widthRest = width & 3;
        int heightRest = height & 3;
        int inputLine = (width + 3) / 4;
        ByteBuffer buff = ByteBuffer.allocate(inputLine * bytesPerBlock);
        if (height >= 4) {
            int yheight = 0;
            while (yheight < height) {
                buff.clear();
                io.get(buff.array());
                if (width >= 4) {
                    int xwidth = 0;
                    while (xwidth < width) {
                        this.DecodeDXTBlock(this.image, buff, xwidth, yheight, 4, 4);
                        xwidth += 4;
                    }
                }
                if (widthRest != 0) {
                    this.DecodeDXTBlock(this.image, buff, widthRest, yheight, widthRest, 4);
                }
                yheight += 4;
            }
        }
        if (heightRest != 0) {
            buff.clear();
            io.get(buff.array());
            if (width >= 4) {
                int xwidth = 0;
                while (xwidth < width) {
                    this.DecodeDXTBlock(this.image, buff, xwidth, heightRest, 4, heightRest);
                    xwidth += 4;
                }
            }
            if (widthRest != 0) {
                this.DecodeDXTBlock(this.image, buff, widthRest, heightRest, widthRest, heightRest);
            }
        }
    }

    protected void DecodeDXTBlock(BufferedImage img, ByteBuffer io, int width, int height, int bw, int bh) {
        int i;
        int[] alpha = null;
        int[] aphrow = null;
        int[] data = null;
        if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            aphrow = new int[4];
            i = 0;
            while (i < 4) {
                aphrow[i] = BufferUtil.readBytesAsInt(io, 2);
                ++i;
            }
        } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            alpha = new int[8];
            i = 0;
            while (i < 2) {
                alpha[i] = BufferUtil.readBytesAsInt(io, 1);
                ++i;
            }
            if (alpha[0] > alpha[1]) {
                i = 0;
                while (i < 6) {
                    alpha[i + 2] = ((6 - i) * alpha[0] + (1 + i) * alpha[1] + 3) / 7;
                    ++i;
                }
            } else {
                i = 0;
                while (i < 4) {
                    alpha[i + 2] = ((4 - i) * alpha[0] + (1 + i) * alpha[1] + 2) / 5;
                    ++i;
                }
                alpha[6] = 0;
                alpha[7] = 255;
            }
            data = new int[6];
            i = 0;
            while (i < 6) {
                data[i] = BufferUtil.readBytesAsInt(io, 1);
                ++i;
            }
        }
        Color8888[] colors = new Color8888[4];
        int i2 = 0;
        while (i2 < 4) {
            colors[i2] = new Color8888();
            ++i2;
        }
        int[] colval = new int[2];
        int i3 = 0;
        while (i3 < 2) {
            colval[i3] = BufferUtil.readBytesAsInt(io, 2);
            ++i3;
        }
        this.GetBlockColors(colval, colors, true);
        int[] row = new int[4];
        int i4 = 0;
        while (i4 < 4) {
            row[i4] = BufferUtil.readBytesAsInt(io, 1);
            ++i4;
        }
        int y = 0;
        while (y < bh) {
            int m_colorRow = row[y];
            short m_alphaRow = 0;
            int m_alphaBits = 0;
            int m_offset = 0;
            if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                m_alphaRow = (short)aphrow[y];
            } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                int ti = y / 2;
                m_alphaBits = data[0 + ti * 3] | data[1 + ti * 3] << 8 | data[2 + ti * 3] << 16;
                m_offset = (y & 1) * 12;
            }
            int x = 0;
            while (x < bw) {
                Color8888 getCol = new Color8888();
                int bits = m_colorRow >> x * 2 & 3;
                getCol.Copy(colors[bits]);
                if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                    bits = m_alphaRow >> x * 4 & 0xF;
                    getCol.a = (short)(bits * 255 / 15);
                } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                    bits = m_alphaBits >> x * 3 + m_offset & 7;
                    getCol.a = (short)alpha[bits];
                }
                this.image.setRGB(width + x, height + y, this.convertPixelColorToValue(getCol));
                ++x;
            }
            ++y;
        }
    }

    protected void LoadDXTByReader(ByteDataFile io) throws IOException {
        if (this.header == null) {
            throw new IOException("DDS Header is NULL");
        }
        this.rowBlockSize = this.header.dwWidth * 4;
        int width = this.header.dwWidth & 0xFFFFFFFC;
        int height = this.header.dwHeight & 0xFFFFFFFC;
        this.bpp = 32;
        int widthRest = width & 3;
        int heightRest = height & 3;
        if (height >= 4) {
            int yheight = 0;
            while (yheight < height) {
                if (width >= 4) {
                    int xwidth = 0;
                    while (xwidth < width) {
                        this.DecodeDXTBlock(this.image, io, xwidth, yheight, 4, 4);
                        xwidth += 4;
                    }
                }
                if (widthRest != 0) {
                    this.DecodeDXTBlock(this.image, io, widthRest, yheight, widthRest, 4);
                }
                yheight += 4;
            }
        }
        if (heightRest != 0) {
            if (width >= 4) {
                int xwidth = 0;
                while (xwidth < width) {
                    this.DecodeDXTBlock(this.image, io, xwidth, heightRest, 4, heightRest);
                    xwidth += 4;
                }
            }
            if (widthRest != 0) {
                this.DecodeDXTBlock(this.image, io, widthRest, heightRest, widthRest, heightRest);
            }
        }
    }

    protected int getPixelColorValue(int x, int y) {
        return this.image.getRGB(x, y);
    }

    protected Color8888 getPixelColor(int x, int y) {
        int colVal = this.image.getRGB(x, y);
        Color8888 color = new Color8888();
        color.a = (short)(colVal >> 24 & 0xFF);
        color.r = (short)(colVal >> 16 & 0xFF);
        color.g = (short)(colVal >> 8 & 0xFF);
        color.b = (short)(colVal & 0xFF);
        return color;
    }

    protected int convertPixelColorToValue(Color8888 color) {
        return (color.a << 24) + (color.r << 16) + (color.g << 8) + color.b;
    }

    protected void DecodeDXTBlock(BufferedImage img, ByteDataFile io, int width, int height, int bw, int bh) throws IOException {
        int i;
        int[] alpha = null;
        int[] aphrow = null;
        int[] data = null;
        if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            aphrow = new int[4];
            i = 0;
            while (i < 4) {
                aphrow[i] = io.readBytesAsInt(2);
                ++i;
            }
        } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
            alpha = new int[8];
            i = 0;
            while (i < 2) {
                alpha[i] = io.readBytesAsInt(1);
                ++i;
            }
            if (alpha[0] > alpha[1]) {
                i = 0;
                while (i < 6) {
                    alpha[i + 2] = ((6 - i) * alpha[0] + (1 + i) * alpha[1] + 3) / 7;
                    ++i;
                }
            } else {
                i = 0;
                while (i < 4) {
                    alpha[i + 2] = ((4 - i) * alpha[0] + (1 + i) * alpha[1] + 2) / 5;
                    ++i;
                }
                alpha[6] = 0;
                alpha[7] = 255;
            }
            data = new int[6];
            i = 0;
            while (i < 6) {
                data[i] = io.readBytesAsInt(1);
                ++i;
            }
        }
        Color8888[] colors = new Color8888[4];
        int i2 = 0;
        while (i2 < 4) {
            colors[i2] = new Color8888();
            ++i2;
        }
        int[] colval = new int[2];
        int i3 = 0;
        while (i3 < 2) {
            colval[i3] = io.readBytesAsInt(2);
            ++i3;
        }
        this.GetBlockColors(colval, colors, true);
        int[] row = new int[4];
        int i4 = 0;
        while (i4 < 4) {
            row[i4] = io.readBytesAsInt(1);
            ++i4;
        }
        int y = 0;
        while (y < bh) {
            int m_colorRow = row[y];
            short m_alphaRow = 0;
            int m_alphaBits = 0;
            int m_offset = 0;
            if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                m_alphaRow = (short)aphrow[y];
            } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                int ti = y / 2;
                m_alphaBits = data[0 + ti * 3] | data[1 + ti * 3] << 8 | data[2 + ti * 3] << 16;
                m_offset = (y & 1) * 12;
            }
            int x = 0;
            while (x < bw) {
                Color8888 getCol = new Color8888();
                int bits = m_colorRow >> x * 2 & 3;
                getCol.Copy(colors[bits]);
                if (FOURCC_DXT3.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                    bits = m_alphaRow >> x * 4 & 0xF;
                    getCol.a = (short)(bits * 255 / 15);
                } else if (FOURCC_DXT5.equals(this.header.ddpfPixelFormat.dwFourCC)) {
                    bits = m_alphaBits >> x * 3 + m_offset & 7;
                    getCol.a = (short)alpha[bits];
                }
                img.setRGB(width + x, height + y, this.convertPixelColorToValue(getCol));
                ++x;
            }
            ++y;
        }
    }

    protected void GetBlockColors(int[] colval, Color8888[] colors, boolean isDXT1) {
        Color565[] srcCols = new Color565[]{new Color565(colval[0]), new Color565(colval[1])};
        int i = 0;
        while (i < 2) {
            colors[i].a = (short)255;
            colors[i].r = (short)(srcCols[i].r << 3 | srcCols[i].r >> 2);
            colors[i].g = (short)(srcCols[i].g << 2 | srcCols[i].g >> 4);
            colors[i].b = (short)(srcCols[i].b << 3 | srcCols[i].b >> 2);
            ++i;
        }
        if (colval[0] > colval[1] || !isDXT1) {
            i = 0;
            while (i < 2) {
                colors[i + 2].a = (short)255;
                colors[i + 2].r = (short)((colors[0].r * (2 - i) + colors[1].r * (1 + i)) / 3);
                colors[i + 2].g = (short)((colors[0].g * (2 - i) + colors[1].g * (1 + i)) / 3);
                colors[i + 2].b = (short)((colors[0].b * (2 - i) + colors[1].b * (1 + i)) / 3);
                ++i;
            }
        } else {
            colors[2].a = (short)255;
            colors[2].r = (short)((colors[0].r + colors[1].r) / 2);
            colors[2].g = (short)((colors[0].g + colors[1].g) / 2);
            colors[2].b = (short)((colors[0].b + colors[1].b) / 2);
            colors[3].a = 0;
            colors[3].r = 0;
            colors[3].g = 0;
            colors[3].b = 0;
        }
    }

    protected void LoadRGB() {
        int width = this.header.dwWidth & 0xFFFFFFFC;
        int height = this.header.dwHeight & 0xFFFFFFFC;
        int bpp = this.header.ddpfPixelFormat.dwRGBBitCount;
    }

    protected class Color565 {
        int b = 5;
        int g = 6;
        int r = 5;

        Color565(int i) {
            this.r = i >> 11 & 0x1F;
            this.g = i >> 5 & 0x3F;
            this.b = i & 0x1F;
        }
    }

    protected class Color8888 {
        short b;
        short g;
        short r;
        short a;

        protected Color8888() {
        }

        protected void Copy(Color8888 src) {
            this.a = src.a;
            this.r = src.r;
            this.g = src.g;
            this.b = src.b;
        }

        public String toString() {
            return String.valueOf(Integer.toHexString(this.hashCode())) + " = [r:" + this.r + ", g:" + this.g + ", b:" + this.b + ", a:" + this.a + "]";
        }
    }

    public class DDSHEADER {
        protected String dwMagic;
        protected int dwSize;
        protected int dwFlags;
        protected int dwHeight;
        protected int dwWidth;
        protected int dwPitchOrLinearSize;
        protected int dwDepth;
        protected int dwMipMapCount;
        protected int[] dwReserved1 = new int[11];
        protected DDPIXEFORMAT ddpfPixelFormat = new DDPIXEFORMAT();
        protected DDCAPS2 ddsCaps = new DDCAPS2();
        protected int dwReserved2;

        public int getDwHeight() {
            return this.dwHeight;
        }

        public void setDwHeight(int dwHeight) {
            this.dwHeight = dwHeight;
        }

        public int getDwWidth() {
            return this.dwWidth;
        }

        public void setDwWidth(int dwWidth) {
            this.dwWidth = dwWidth;
        }

        public void setPixelFormatStr(String pixelFormat) {
            this.ddpfPixelFormat.dwFourCC = pixelFormat;
        }

        public String getPixelFormatStr() {
            return this.ddpfPixelFormat.dwFourCC;
        }

        class DDCAPS2 {
            int dwCaps1;
            int dwCaps2;
            int[] dwReserved = new int[2];

            DDCAPS2() {
            }
        }

        class DDPIXEFORMAT {
            protected int dwSize;
            protected int dwFlags;
            protected String dwFourCC;
            protected int dwRGBBitCount;
            protected int dwRBitMask;
            protected int dwGBitMask;
            protected int dwBBitMask;
            protected int dwRGBAlphaBitMask;

            DDPIXEFORMAT() {
            }
        }
    }

    protected class DXT5Block {
        short[] alpha = new short[2];
        short[] data = new short[6];
        Color565[] colors = new Color565[2];
        short[] row = new short[4];

        protected DXT5Block() {
        }
    }
}

