/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.imageio;

import com.zsword.modules.imageio.UnknowPixelFormatException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DDSImgFileReader {
    private static final int DDPF_FOURCC = 4;
    private static final int DDSCAPS_TEXTURE = 4096;

    protected static Dimension readHeaderDxt3(ByteBuffer buffer) {
        buffer.rewind();
        byte[] magic = new byte[4];
        buffer.get(magic);
        assert (new String(magic).equals("DDS "));
        int version = buffer.getInt();
        assert (version == 124);
        int flags = buffer.getInt();
        int height = buffer.getInt();
        int width = buffer.getInt();
        int pixels = buffer.getInt();
        int depth = buffer.getInt();
        int mipmaps = buffer.getInt();
        buffer.position(buffer.position() + 44);
        int pixelFormatSize = buffer.getInt();
        int fourCC = buffer.getInt();
        assert (fourCC == 4);
        byte[] format = new byte[4];
        buffer.get(format);
        assert (new String(format).equals("DXT3"));
        int bpp = buffer.getInt();
        buffer.getInt();
        buffer.getInt();
        buffer.getInt();
        buffer.getInt();
        int unknown = buffer.getInt();
        assert (unknown == 4096);
        int ddsCaps = buffer.getInt();
        buffer.position(buffer.position() + 12);
        return new Dimension(width, height);
    }

    public static BufferedImage readDxt3(ByteBuffer buffer, String pixelFormat) throws UnknowPixelFormatException {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Dimension dimension = DDSImgFileReader.readHeaderDxt3(buffer);
        return DDSImgFileReader.readDxt3Buffer(buffer, dimension.width, dimension.height, pixelFormat);
    }

    public static BufferedImage readDxt3Buffer(ByteBuffer buffer, int width, int height, String pixelFormat) throws UnknowPixelFormatException {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int[] pixels = null;
        int[] alphas = null;
        int alphaLen = 0;
        if (pixelFormat.equals("DXT1")) {
            pixels = new int[4];
            alphas = new int[4];
        } else if (pixelFormat.equals("DXT3")) {
            pixels = new int[16];
            alphas = new int[16];
            alphaLen = 8;
        } else if (pixelFormat.equals("DXT5")) {
            pixels = new int[32];
            alphas = new int[32];
            alphaLen = 8;
        } else {
            throw new UnknowPixelFormatException("Unknow dds pixelFormat: " + pixelFormat);
        }
        BufferedImage result = new BufferedImage(width, height, 3);
        int numTilesWide = width / 4;
        int numTilesHigh = height / 4;
        int i = 0;
        while (i < numTilesHigh) {
            int j = 0;
            while (j < numTilesWide) {
                long alphaData = 1L;
                if (alphaLen != 0) {
                    if (alphaLen == 4) {
                        alphaData = buffer.getLong();
                    } else if (alphaLen == 8) {
                        alphaData = buffer.getLong();
                    }
                }
                int k = alphas.length - 1;
                while (k >= 0) {
                    if (alphaLen == 0) {
                        alphas[k] = 240;
                    } else {
                        alphas[k] = (int)(alphaData >>> k * 4) & 0xF;
                        int n = k;
                        alphas[n] = alphas[n] << 4;
                    }
                    --k;
                }
                short minColor = buffer.getShort();
                short maxColor = buffer.getShort();
                Color[] lookupTable = DDSImgFileReader.expandLookupTable(minColor, maxColor);
                int colorData = buffer.getInt();
                int k2 = pixels.length - 1;
                while (k2 >= 0) {
                    int colorCode = colorData >>> k2 * 2 & 3;
                    pixels[k2] = alphas[k2] << 24 | DDSImgFileReader.getPixel888(DDSImgFileReader.multiplyAlpha(lookupTable[colorCode], alphas[k2]));
                    --k2;
                }
                result.setRGB(j * 4, i * 4, 4, 4, pixels, 0, 0);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Color multiplyAlpha(Color color, int alpha) {
        Color result = new Color();
        double alphaF = (double)alpha / 256.0;
        result.r = (int)((double)color.r * alphaF);
        result.g = (int)((double)color.g * alphaF);
        result.b = (int)((double)color.b * alphaF);
        return result;
    }

    protected static Color getColor565(int pixel) {
        Color color = new Color();
        color.r = (int)((long)pixel & 0xF800L) >>> 8;
        color.g = (int)((long)pixel & 0x7E0L) >>> 3;
        color.b = (int)((long)pixel & 0x1FL) << 3;
        return color;
    }

    private static Color[] expandLookupTable(short minColor, short maxColor) {
        Color[] result = new Color[]{DDSImgFileReader.getColor565(minColor), DDSImgFileReader.getColor565(maxColor), new Color(), new Color()};
        result[2].r = (2 * result[0].r + result[1].r + 1) / 3;
        result[2].g = (2 * result[0].g + result[1].g + 1) / 3;
        result[2].b = (2 * result[0].b + result[1].b + 1) / 3;
        result[3].r = (result[0].r + 2 * result[1].r + 1) / 3;
        result[3].g = (result[0].g + 2 * result[1].g + 1) / 3;
        result[3].b = (result[0].b + 2 * result[1].b + 1) / 3;
        return result;
    }

    protected static int getPixel888(Color color) {
        int r = color.r;
        int g = color.g;
        int b = color.b;
        return r << 16 | g << 8 | b;
    }

    protected static class Color {
        private int r;
        private int g;
        private int b;

        public Color() {
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        public Color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Color color = (Color)o;
            if (this.b != color.b) {
                return false;
            }
            if (this.g != color.g) {
                return false;
            }
            return this.r == color.r;
        }

        public int hashCode() {
            int result = this.r;
            result = 29 * result + this.g;
            result = 29 * result + this.b;
            return result;
        }
    }
}

