/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.fileio.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ConfigIOUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static JSONObject loadConfig(String filePath) throws IOException {
        return ConfigIOUtils.loadConfig(filePath, false);
    }

    public static JSONObject loadPropertiesText(String filePath) throws IOException {
        BufferedReader reader = null;
        JSONObject result = null;
        try {
            InputStream input = null;
            input = filePath.startsWith("file:") ? new FileInputStream(filePath.substring(5)) : ConfigIOUtils.class.getResourceAsStream(filePath);
            reader = new BufferedReader(new InputStreamReader(input, DEFAULT_ENCODING));
            result = new JSONObject(true);
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] strs = line.split("\\s*=\\s*");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("label", strs[1]);
                result.put(strs[0], (Object)map);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static JSONObject loadConfig(String filePath, boolean ordered) throws IOException {
        BufferedReader reader = null;
        JSONObject json = null;
        try {
            try {
                InputStream input = null;
                input = filePath.startsWith("file:") ? new FileInputStream(filePath.substring(5)) : ConfigIOUtils.class.getResourceAsStream(filePath);
                reader = new BufferedReader(new InputStreamReader(input, DEFAULT_ENCODING));
                StringBuffer buffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line.trim());
                }
                ArrayList<Feature> features = new ArrayList<Feature>();
                if (ordered) {
                    features.add(Feature.OrderedField);
                }
                json = JSONObject.parseObject(buffer.toString(), features.toArray(new Feature[features.size()]));
            }
            catch (Exception e) {
                throw new IOException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519" + filePath, e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return json;
    }

    public static JSONArray loadArrayConfig(String filePath) throws IOException {
        BufferedReader reader = null;
        JSONArray json = null;
        try {
            InputStream input = null;
            input = filePath.startsWith("file:") ? new FileInputStream(filePath.substring(5)) : ConfigIOUtils.class.getResourceAsStream(filePath);
            reader = new BufferedReader(new InputStreamReader(input, DEFAULT_ENCODING));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line.trim());
            }
            json = JSONArray.parseArray(buffer.toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return json;
    }

    public static void saveConfig(Object config, String filePath) throws IOException {
        if (config == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            filePath = filePath.startsWith("file:") ? filePath.substring(5) : ConfigIOUtils.class.getResource(filePath).getFile();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), DEFAULT_ENCODING));
            String jsonStr = JSONObject.toJSONString(config, true);
            writer.write(jsonStr);
            writer.flush();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File loadRemoteConfigFile(String urlStr, String filePath) throws IOException {
        URLConnection conn = null;
        FilterOutputStream output = null;
        File config = null;
        try {
            URL url = new URL(urlStr);
            conn = url.openConnection();
            InputStream input = conn.getInputStream();
            filePath = filePath.startsWith("file:") ? filePath.substring(5) : ConfigIOUtils.class.getResource(filePath).getFile();
            output = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] buff = new byte[512000];
            int c = -1;
            while ((c = input.read(buff)) > 0) {
                ((BufferedOutputStream)output).write(buff, 0, c);
            }
            ((BufferedOutputStream)output).flush();
            config = new File(filePath);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return config;
    }
}

