/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.modules.compress;

public abstract class H7CompressUtils {
    private static int composeBits(int H, int HU, int HL) {
        return H >> HL & (1 << HU - HL + 1) - 1;
    }

    public static byte[] decompress(byte[] src, int decompressSize, int hL) {
        byte[] outbuf = new byte[decompressSize];
        int datalen = src.length;
        int numbput = 0;
        int numbget = 0;
        block0: while (numbput < datalen) {
            int numb5 = src[numbput++] & 0xFF;
            int numb6 = 0;
            while (numbget != decompressSize) {
                if ((numb5 & 1) > 0) {
                    int a = src[numbput++] & 0xFF;
                    int b = src[numbput++] & 0xFF;
                    int h = a * 256 + b;
                    int numb7 = H7CompressUtils.composeBits(h, 15, hL) + 3;
                    int numb8 = H7CompressUtils.composeBits(h, hL - 1, 0);
                    int numb11 = numb7 - 1;
                    int j = 0;
                    while (j <= numb11) {
                        if (numbget - numb8 < 0 || numb8 == 0) {
                            outbuf[numbget++] = -1;
                        } else {
                            outbuf[numbget] = outbuf[numbget - numb8];
                            ++numbget;
                        }
                        ++j;
                    }
                } else {
                    outbuf[numbget++] = src[numbput++];
                }
                numb5 >>= 1;
                if (++numb6 <= 7) continue;
                continue block0;
            }
        }
        return outbuf;
    }
}

