/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mhxeditor.data;

import com.alibaba.fastjson.JSONObject;
import com.zsword.modules.io.ByteDataFile;
import com.zsword.modules.utils.data.BitDataCalc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MHXSavDataFile
extends ByteDataFile {
    private static final String DATATEXT_ENCODING = "UTF-8";
    private Map<String, Object> headerData = null;
    private List<Map<String, Object>> characterOffsetList = null;
    private Map<String, Map<String, Object>> character = null;

    public MHXSavDataFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    public MHXSavDataFile(File file) throws FileNotFoundException {
        this(file, "rw");
    }

    public void loadHeader(JSONObject struct) throws IOException {
        HashMap<String, Object> header = new HashMap<String, Object>();
        this.seek(0L);
        for (String key : struct.keySet()) {
            JSONObject map = struct.getJSONObject(key);
            String info = (String)map.get("info");
            long offset = Long.parseLong(key, 16);
            int size = (Integer)map.get("size");
            this.seek(offset);
            header.put(info, this.readBytesAsInt(size));
        }
        this.headerData = header;
    }

    public Map<String, Map<String, Object>> loadDataOffset(int idx, JSONObject struct) throws IOException {
        int baseAddr = (Integer)this.headerData.get("Offset to character" + idx);
        this.seek(baseAddr);
        LinkedHashMap<String, Map<String, Object>> infoData = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("info", "Data offset");
        data.put("offset", baseAddr);
        infoData.put("offset", data);
        for (String key : struct.keySet()) {
            JSONObject map = struct.getJSONObject(key);
            String info = (String)map.get("info");
            if (info.toLowerCase().startsWith("unknow")) continue;
            long offset = Long.parseLong(key, 16);
            this.seek(offset);
            data = new HashMap();
            data.putAll(map);
            data.put("offset", (long)baseAddr + offset);
            infoData.put(info, data);
        }
        this.character = infoData;
        return this.character;
    }

    public Map<String, Object> loadCharacter() throws IOException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (String key : this.character.keySet()) {
            if ("offset".equals(key)) continue;
            Map<String, Object> map = this.character.get(key);
            long offset = (Long)map.get("offset");
            int size = (Integer)map.get("size");
            if (size > 32) continue;
            this.seek(offset);
            Object val = null;
            if (size <= 4) {
                val = this.readBytesAsInt(size);
            } else if (size <= 8) {
                val = this.readBytesAsLong(size);
            } else {
                String encoding = (String)map.get("encoding");
                val = this.readStringData(size, encoding);
            }
            data.put(key, val);
        }
        return data;
    }

    public void putCharacterInfo(String attrName, Object value) throws IOException {
        Map<String, Object> map = this.character.get(attrName);
        long offset = (Long)map.get("offset");
        this.seek(offset);
        int size = (Integer)map.get("size");
        String type = (String)map.get("type");
        if ("string".equals(type)) {
            String str = (String)value;
            String encoding = (String)map.get("encoding");
            this.writeStringData(str, size, encoding);
            return;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            value = "bytes".equals(type) ? Integer.valueOf(Integer.parseInt((String)value, 16)) : Integer.valueOf(Integer.parseInt((String)value));
        }
        this.writeInt((Integer)value, size);
    }

    public List<Map<String, Object>> loadEquipmentBox(Map<String, Map<String, Object>> struct) throws IOException {
        long offset = (Long)this.character.get("Equipment box").get("offset");
        int total = 1400;
        this.seek(offset);
        return this.loadEquipmentList(struct, total);
    }

    private List<Map<String, Object>> loadEquipmentList(Map<String, Map<String, Object>> struct, int count) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int pos = (int)this.getFilePointer();
        int size = 36;
        int i = 0;
        while (i < count) {
            int offset = pos + i * size;
            int num = 0;
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (String key : struct.keySet()) {
                Map<String, Object> def = struct.get(key);
                if ("offset".equals(key)) {
                    data.put("offset", offset);
                    continue;
                }
                Integer len = (Integer)def.get("length");
                if (len == null) continue;
                num += len.intValue();
                if (key.startsWith("unknow")) {
                    this.skipBytes(len);
                    continue;
                }
                Object val = this.readBytesAsInt(len);
                if (len != null) {
                    val = String.format("%0" + len * 2 + 'X', val);
                }
                data.put(key, (Integer)val);
            }
            if (num < size) {
                this.skipBytes(size - num);
            }
            list.add(data);
            ++i;
        }
        return list;
    }

    public List<Map<String, Object>> loadItemBox(Map<String, Map<String, Object>> struct) throws IOException {
        long offset = (Long)this.character.get("Item box").get("offset");
        int total = 1400;
        this.seek(offset);
        return this.loadItemList(struct, total);
    }

    public List<Map<String, Object>> loadCarryItem(Map<String, Map<String, Object>> struct) throws IOException {
        long offset = (Long)this.character.get("Item slots").get("offset");
        int total = 24;
        this.seek(offset);
        return this.loadItemList(struct, total);
    }

    private List<Map<String, Object>> loadItemList(Map<String, Map<String, Object>> struct, int total) throws IOException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        byte[] data = new byte[total * 18 / 8];
        this.read(data);
        int byteIdx = 0;
        int bitOffset = 0;
        int val = 0;
        int itemId = 0;
        int itemCount = 0;
        int i = 0;
        while (i < total) {
            byteIdx = i * 18 / 8;
            bitOffset = i * 18 % 8;
            byte[] buff = new byte[3];
            int n = 0;
            while (n < buff.length) {
                buff[n] = data[byteIdx++];
                ++n;
            }
            val = BitDataCalc.readBitsBytes(buff, 18, bitOffset);
            String str = String.format("%18s", Integer.toBinaryString(val)).replace(" ", "0");
            itemId = Integer.parseInt(str.substring(7, 18), 2);
            itemCount = Integer.parseInt(str.substring(0, 7), 2);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("no", i + 1);
            map.put("item", itemId);
            map.put("count", itemCount);
            dataList.add(map);
            ++i;
        }
        return dataList;
    }

    public void writeBoxItem(int idx, int itemId, int count) throws IOException {
        Map<String, Object> infoData = this.character.get("Item box");
        long offset = (Long)infoData.get("offset");
        this.writeItemData(offset, idx, itemId, count);
    }

    public void writeCarryItem(int idx, int itemId, int count) throws IOException {
        Map<String, Object> infoData = this.character.get("Item slots");
        long offset = (Long)infoData.get("offset");
        this.writeItemData(offset, idx, itemId, count);
    }

    private void writeItemData(long offset, int idx, int itemId, int count) throws IOException {
        int byteIdx = idx * 18 / 8;
        int bitOffset = idx * 18 % 8;
        this.seek(offset += (long)byteIdx);
        byte[] data = new byte[3];
        this.read(data);
        int val = (count << 11) + itemId;
        BitDataCalc.writeBitsBytes(data, val, 18, bitOffset);
        this.seek(offset);
        this.write(data);
    }

    public List<Map<String, Object>> loadCatList(Map<String, Map<String, Object>> struct) throws IOException {
        Map<String, Object> infoData = this.character.get("Cat list");
        long dataOffset = (Long)infoData.get("offset");
        int count = 50;
        int size = 319;
        this.seek(dataOffset);
        int pos = (int)this.getFilePointer();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < count) {
            int offset = pos + i * size;
            int num = 0;
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (String key : struct.keySet()) {
                Map<String, Object> def = struct.get(key);
                if ("offset".equals(key)) {
                    data.put("offset", offset);
                    continue;
                }
                Integer len = (Integer)def.get("length");
                if (len == null) continue;
                num += len.intValue();
                if (key.startsWith("unknow")) {
                    this.skipBytes(len);
                    continue;
                }
                Object val = null;
                String type = (String)def.get("type");
                if ("string".equals(type)) {
                    String encoding = (String)def.get("encoding");
                    val = this.readStringData(len, encoding);
                } else {
                    val = this.readBytesAsInt(len);
                    if (len != null) {
                        val = String.format("%0" + len * 2 + 'X', val);
                    }
                }
                data.put(key, val);
            }
            if (num < size) {
                this.skipBytes(size - num);
            }
            list.add(data);
            ++i;
        }
        return list;
    }

    public String readStringData(int len, String encoding) throws IOException {
        encoding = encoding == null ? DATATEXT_ENCODING : encoding;
        return this.readBytesAsString(len, DATATEXT_ENCODING, false);
    }

    public void writeStringData(String str, int len, String encoding) throws IOException {
        int count = this.writeString(str, encoding = encoding == null ? DATATEXT_ENCODING : encoding, false);
        int r = len - count - 1;
        if (r > 0) {
            byte[] emptyData = new byte[r];
            this.write(emptyData);
        }
    }
}

