/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mhxeditor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zsword.mhxeditor.CatListPanel;
import com.zsword.mhxeditor.CharacterPanel;
import com.zsword.mhxeditor.EquipmentBoxPanel;
import com.zsword.mhxeditor.ItemBoxPanel;
import com.zsword.mhxeditor.data.MHXSavDataFile;
import com.zsword.modules.fileio.utils.ConfigIOUtils;
import com.zsword.modules.swing.FrameBase;
import com.zsword.modules.swing.utils.ComponentUtils;
import com.zsword.saveditor.MHsavEditSupport;
import com.zsword.saveditor.gui.ValueCodesDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class MHXSavEditor
extends FrameBase
implements ItemListener,
MHsavEditSupport {
    private static final String KEY_ATTR = "key";
    private static final String VALUE_ATTR = "value";
    private static final String LABEL_ATTR = "label";
    private static final String COMMENT_ATTR = "comment";
    private static final String APP_NAME = "MHX Sav Editor";
    private static final String _DEVPATH = "file://D:/EclipseProjs/zsword/javaee/desktopApps/gameTools/MHsavEditor/SavEditor";
    private static final String LANG_PATH = "/lang_zh_CN.json";
    private static final String SETTINGS_PATH = "/settings.json";
    private static final String EQUIPT_LIST_PATH = "/EquiptList.json";
    private static final String EQUIPT_TYPE_PATH = "/EquiptType.json";
    private static final String EQUIPT_NATURE_PATH = "/EquiptNature.json";
    private static final String EQUIPT_DECORATION_PATH = "/EquiptDecoration.json";
    private static final String ITEM_LIST_PATH = "/ItemList.json";
    private static final String STONE_SKILL_PATH = "/StoneSkill.json";
    private static final String INSECT_TYPE_PATH = "/InsectType.json";
    private static final boolean _EnableMemEdit = true;
    private JSONObject appLang = null;
    private JSONObject appSettings = null;
    private JSONObject headerStruct = null;
    private JSONObject characterStruct = null;
    private JSONObject equiptListCodes = null;
    private JSONObject equiptTypeCodes = null;
    private JSONObject equiptNatureCodes = null;
    private JSONObject equiptDecorationCodes = null;
    private JSONObject itemListCodes = null;
    private JSONObject stoneSkillCodes = null;
    private JSONObject insectTypeCodes = null;
    private JSONObject catSkillCodes = null;
    private JSONObject catPassiveSkillCodes = null;
    private MHXSavDataFile savDataFile = null;
    private JTabbedPane mainTabPane;
    private JComboBox savIndexCombo = null;
    private CharacterPanel characterPanel;
    private ValueCodesDialog valueCodesDlg = null;
    private ItemBoxPanel personItemPanel = null;
    private EquipmentBoxPanel equiptBoxPanel = null;
    private ItemBoxPanel itemBoxPanel = null;
    private CatListPanel catListPanel = null;
    private Map<String, JComponent> settingsFieldMap = new HashMap<String, JComponent>();
    private Map<String, JButton> actButtonMap = new HashMap<String, JButton>();
    private JLabel statusLabel = null;
    private final String settingsPath;
    private final String languagePath;
    private String valueCodeType = null;

    private static String loadDataFilePath(String path) {
        if (1 > _State) {
            path = _DEVPATH + path;
        }
        return path;
    }

    public MHXSavEditor() {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(lookAndFeels[1].getClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String languagePath = MHXSavEditor.loadDataFilePath(LANG_PATH);
        String settingsPath = MHXSavEditor.loadDataFilePath(SETTINGS_PATH);
        this.languagePath = languagePath;
        this.settingsPath = settingsPath;
        this.loadLanguage();
        String cfgPath = null;
        try {
            cfgPath = settingsPath;
            this.appSettings = ConfigIOUtils.loadConfig(cfgPath);
            this.loadStructFile();
            this.loadCodesFile();
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            errMsg = errMsg != null ? "" : "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519-" + e.toString();
            this.handleError(e, errMsg);
            this.exit();
        }
        this.setTitle("MHX Sav Editor ver 0.22");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MHXSavEditor.this.onDestroy();
            }
        });
        this.initItems();
        if (-1 == _State) {
            this.loadSavFile(new File("D:/Games/3DS/Roms/MHX/system"));
        }
    }

    private void loadStructFile() throws IOException {
        String cfgPath = MHXSavEditor.loadDataFilePath("/struct/MHX_Header.json");
        this.headerStruct = ConfigIOUtils.loadConfig(cfgPath);
        cfgPath = MHXSavEditor.loadDataFilePath("/struct/MHX_Character.json");
        this.characterStruct = ConfigIOUtils.loadConfig(cfgPath, true);
    }

    private void loadCodesFile() throws IOException {
        String cfgPath = MHXSavEditor.loadDataFilePath("/data/MHX/Item_ids.txt");
        this.itemListCodes = ConfigIOUtils.loadPropertiesText(cfgPath);
        cfgPath = MHXSavEditor.loadDataFilePath("/data/MHX/Equipment_type.txt");
        this.equiptTypeCodes = ConfigIOUtils.loadPropertiesText(cfgPath);
        cfgPath = MHXSavEditor.loadDataFilePath("/data/MHX/Stone_skill.txt");
        this.stoneSkillCodes = ConfigIOUtils.loadPropertiesText(cfgPath);
        cfgPath = MHXSavEditor.loadDataFilePath("/data/MHX/Cat_skill.txt");
        this.catSkillCodes = ConfigIOUtils.loadPropertiesText(cfgPath);
        cfgPath = MHXSavEditor.loadDataFilePath("/data/MHX/Cat_passiveskill.txt");
        this.catPassiveSkillCodes = ConfigIOUtils.loadPropertiesText(cfgPath);
    }

    private void loadLanguage() {
        String filePath = this.languagePath;
        try {
            this.appLang = ConfigIOUtils.loadConfig(filePath);
        }
        catch (IOException e) {
            this.handleError(e, String.format("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6[%s]\u51fa\u9519", filePath));
        }
    }

    protected void initItems() {
        GUIAction[] actions;
        Dimension size = new Dimension(1200, 600);
        this.setPreferredSize(size);
        this.setJMenuBar(this.initMenubar());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        GUIAction[] gUIActionArray = actions = new GUIAction[]{GUIAction.OpenSav, GUIAction.CheatAllItem, GUIAction.Exit};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            GUIAction act = gUIActionArray[n2];
            String actName = act.name();
            JSONObject lang = this.appLang.getJSONObject(actName);
            JButton btn = new JButton(lang.getString(LABEL_ATTR));
            btn.setActionCommand(actName);
            btn.setToolTipText(lang.getString(COMMENT_ATTR));
            btn.addActionListener(this);
            toolbar.add(btn);
            toolbar.addSeparator();
            this.actButtonMap.put(actName, btn);
            ++n2;
        }
        this.savIndexCombo = new JComboBox();
        this.savIndexCombo.addItemListener(this);
        toolbar.add(this.savIndexCombo);
        this.add((Component)toolbar, "North");
        JTabbedPane tabPane = new JTabbedPane();
        CharacterPanel infoPanel = new CharacterPanel();
        tabPane.add("\u89d2\u8272\u4fe1\u606f", infoPanel);
        this.characterPanel = infoPanel;
        EquipmentBoxPanel equipmentPanel = null;
        equipmentPanel = this.initEquipmentBoxPanel(EquipmentBoxPanel.BoxType.EquiptBox);
        tabPane.add("\u88c5\u5907\u7bb1", equipmentPanel);
        this.equiptBoxPanel = equipmentPanel;
        ItemBoxPanel itemPanel = this.initItemBoxPanel(ItemBoxPanel.BoxType.CarryItem);
        tabPane.add("\u968f\u8eab\u9053\u5177", itemPanel);
        this.personItemPanel = itemPanel;
        itemPanel = this.initItemBoxPanel(ItemBoxPanel.BoxType.ItemBox);
        tabPane.add("\u9053\u5177\u7bb1", itemPanel);
        this.itemBoxPanel = itemPanel;
        CatListPanel catPanel = this.initCatListPanel();
        tabPane.add("\u968f\u4ece\u732b", catPanel);
        this.catListPanel = catPanel;
        tabPane.setVisible(false);
        this.add(tabPane);
        this.mainTabPane = tabPane;
        JToolBar statusBar = new JToolBar();
        statusBar.setFloatable(false);
        JLabel statusLabel = new JLabel("\u672a\u8f7d\u5165");
        statusBar.add(statusLabel);
        this.add((Component)statusBar, "South");
        this.statusLabel = statusLabel;
        this.pack();
        this.center();
    }

    private JMenuBar initMenubar() {
        GUIAction[] actions;
        String labelFmt = "%s(%s)";
        JMenuBar menubar = new JMenuBar();
        String key = "File";
        JSONObject config = this.appLang.getJSONObject(key);
        char keychar = key.charAt(0);
        JMenu menu = new JMenu(String.format(labelFmt, config.get(LABEL_ATTR), Character.valueOf(keychar)));
        menu.setMnemonic(Character.toLowerCase(keychar));
        menu.setToolTipText((String)config.get(COMMENT_ATTR));
        JMenuItem item = null;
        GUIAction[] gUIActionArray = actions = new GUIAction[]{GUIAction.OpenSav, GUIAction.Exit};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            GUIAction act = gUIActionArray[n2];
            String actName = act.name();
            config = this.appLang.getJSONObject(actName);
            keychar = actName.charAt(0);
            item = new JMenuItem(String.format(labelFmt, config.get(LABEL_ATTR), Character.valueOf(keychar)));
            item.setMnemonic(Character.toLowerCase(keychar));
            item.setActionCommand(actName);
            item.setToolTipText((String)config.get(COMMENT_ATTR));
            item.addActionListener(this);
            menu.add(item);
            ++n2;
        }
        menubar.add(menu);
        return menubar;
    }

    private ItemBoxPanel initItemBoxPanel(ItemBoxPanel.BoxType type) {
        ItemBoxPanel panel;
        final ItemBoxPanel tablePanel = panel = new ItemBoxPanel(this.appSettings, this.appLang, type);
        panel.addTableSelectionListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton()) {
                    String codeKey = tablePanel.getSelectedCellValueCodeKey();
                    MHXSavEditor.this.showValueCodesPanel(codeKey);
                }
            }
        });
        return panel;
    }

    private EquipmentBoxPanel initEquipmentBoxPanel(EquipmentBoxPanel.BoxType type) {
        EquipmentBoxPanel panel;
        final EquipmentBoxPanel tablePanel = panel = new EquipmentBoxPanel(this.appSettings, this.appLang, type);
        panel.addTableSelectionListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton()) {
                    String codeKey = tablePanel.getSelectedCellValueCodeKey();
                    MHXSavEditor.this.showValueCodesPanel(codeKey);
                }
            }
        });
        return panel;
    }

    private CatListPanel initCatListPanel() {
        CatListPanel panel;
        final CatListPanel tablePanel = panel = new CatListPanel(this.appSettings, this.appLang);
        panel.addTableSelectionListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton()) {
                    String codeKey = tablePanel.getSelectedCellValueCodeKey();
                    MHXSavEditor.this.showValueCodesPanel(codeKey);
                }
            }
        });
        return panel;
    }

    private void showValueCodesPanel(String type) {
        if (type.equals(this.valueCodeType)) {
            return;
        }
        JSONObject codes = null;
        if ("equiptId".equals(type)) {
            codes = this.equiptListCodes;
        } else if ("Equipt-type".equals(type)) {
            codes = this.equiptTypeCodes;
        } else if ("Equipt-natureType".equals(type)) {
            codes = this.equiptNatureCodes;
        } else if ("Equipt-stoneSkill".equals(type)) {
            codes = this.stoneSkillCodes;
        } else if ("Equipt-decoration".equals(type)) {
            codes = this.equiptDecorationCodes;
        } else if ("Equipt-insectType".equals(type)) {
            codes = this.insectTypeCodes;
        } else if ("item".equals(type)) {
            codes = this.itemListCodes;
        } else if ("Cat-skill".equals(type)) {
            codes = this.catSkillCodes;
        } else if ("Cat-psvskill".equals(type)) {
            codes = this.catPassiveSkillCodes;
        }
        this.valueCodeType = type;
        if (codes == null) {
            if (this.valueCodesDlg != null) {
                this.valueCodesDlg.setVisible(false);
            }
            return;
        }
        if (this.valueCodesDlg == null) {
            this.valueCodesDlg = new ValueCodesDialog();
        }
        this.valueCodesDlg.loadCodes(codes);
        this.valueCodesDlg.setVisible(true);
    }

    protected void openSav() {
        String workDir = this.appSettings.getString("savFileDir");
        File savFile = this.showOpenFileDialog(workDir, "system*", "MHX sav(system*)");
        if (savFile == null) {
            return;
        }
        workDir = savFile.getParentFile().getPath();
        this.appSettings.put("savFileDir", (Object)workDir);
        this.loadSavFile(savFile);
    }

    protected void loadSavFile(File savFile) {
        try {
            if (this.savDataFile != null) {
                this.savDataFile.close();
            }
            MHXSavDataFile dataFile = new MHXSavDataFile(savFile);
            dataFile.loadHeader(this.headerStruct);
            this.savDataFile = dataFile;
            this.savIndexCombo.removeAllItems();
            int i = 1;
            while (i < 4) {
                this.savIndexCombo.addItem(i);
                ++i;
            }
            this.setStatusText("\u5b58\u6863\u6587\u4ef6:" + savFile.getPath());
        }
        catch (Exception e) {
            this.handleError(e, "\u8bfb\u53d6\u5b58\u6863\u6587\u4ef6\u51fa\u9519-");
        }
    }

    protected void loadCharacter(int idx) {
        try {
            if (this.savDataFile == null) {
                return;
            }
            this.savDataFile.loadDataOffset(idx, this.characterStruct);
            if (this.mainTabPane != null) {
                if (this.characterPanel != null) {
                    this.characterPanel.loadDataFile(this.savDataFile);
                }
                if (this.equiptBoxPanel != null) {
                    this.equiptBoxPanel.loadDataFile(this.savDataFile);
                }
                if (this.personItemPanel != null) {
                    this.personItemPanel.loadDataFile(this.savDataFile);
                }
                if (this.itemBoxPanel != null) {
                    this.itemBoxPanel.loadDataFile(this.savDataFile);
                }
                if (this.catListPanel != null) {
                    this.catListPanel.loadDataFile(this.savDataFile);
                }
                this.mainTabPane.setSelectedIndex(0);
                this.mainTabPane.setVisible(true);
            }
        }
        catch (Exception e) {
            this.handleError(e, "\u8bfb\u53d6\u89d2\u8272\u6570\u636e\u51fa\u9519-");
        }
    }

    protected void saveSavAs() {
        String workDir = this.appSettings.getString("savFileDir");
        File saveFile = this.showSaveFileDialog(workDir);
        if (saveFile == null) {
            return;
        }
        workDir = saveFile.getParentFile().getPath();
        this.appSettings.put("savFileDir", (Object)workDir);
        try {
            this.savDataFile.writeToFile(saveFile, 0L, this.savDataFile.length());
            this.showMessage("\u6210\u529f\u4fdd\u5b58\u5b58\u6863\u6587\u4ef6\u4e3a" + saveFile.getPath());
        }
        catch (Exception e) {
            this.handleError(e, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u51fa\u9519-");
        }
    }

    protected void cheatAllItem() {
        if (this.savDataFile == null) {
            return;
        }
        try {
            String settingKey = "allItemCodes";
            String str = this.appSettings.getString(settingKey);
            str = JOptionPane.showInputDialog(this, "\u8bf7\u8f93\u5165\u9053\u5177ID\u8303\u56f4(\u683c\u5f0fzz:xx~yy,xx),zz:\u4ee3\u8868\u9053\u5177\u683c\u5e8f\u53f7,\u7701\u7565\u5219\u9ed8\u8ba4\u4ece1\u5f00\u59cb\u586b\u5145,\u9053\u5177\u603b\u6570\u4e0d\u80fd\u8d85\u8fc7\u9053\u5177\u7bb1\u603b\u683c\u6570.", str);
            if (str == null) {
                return;
            }
            String[] strs = str.split("\\s*,\\s*");
            int total = 1400;
            int idx = 0;
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] subs = s.split("\\s*:\\s*");
                if (subs.length > 1) {
                    idx = Integer.parseInt(subs[0]) - 1;
                    s = subs[1];
                }
                if ((subs = s.split("\\s*~\\s*")).length > 1) {
                    int start = Integer.parseInt(subs[0]);
                    int end = Integer.parseInt(subs[1]);
                    int i = start;
                    while (i <= end) {
                        if (idx <= total) {
                            this.savDataFile.writeBoxItem(idx++, i, 80 + (int)(Math.random() * 20.0));
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.savDataFile.writeBoxItem(idx++, Integer.parseInt(subs[0]), 80 + (int)(Math.random() * 20.0));
                }
                ++n2;
            }
            this.appSettings.put(settingKey, (Object)str);
            this.mainTabPane.setSelectedComponent(this.itemBoxPanel);
            this.itemBoxPanel.loadDataFile(this.savDataFile);
            this.showMessage("\u4fee\u6539\u5168\u9053\u5177\u6210\u529f");
        }
        catch (Exception e) {
            this.handleError(e, "\u4fee\u6539\u5168\u9053\u5177\u51fa\u9519-");
        }
    }

    protected Object getSettingValue(String fieldName) {
        JComponent field = this.settingsFieldMap.get(fieldName);
        Object value = ComponentUtils.getValue(field);
        return value;
    }

    protected void setStatusText(String msg) {
        this.statusLabel.setText(msg);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String actName = StringUtils.uncapitalize((String)cmd);
        try {
            Method method = this.getClass().getDeclaredMethod(actName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-" + cmd + ": ");
        }
    }

    protected static void textToJson() {
        File file = new File(String.valueOf(_DEVPATH.substring(7)) + "/data" + ITEM_LIST_PATH);
        String line = null;
        try {
            JSONObject json = new JSONObject(true);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                line = line.toUpperCase().trim().replaceAll("\\s+", ":");
                String[] strs = line.split(":");
                JSONObject data = new JSONObject();
                if (strs.length < 2) {
                    System.out.println(line);
                }
                if (strs.length <= 3) continue;
                data.put(LABEL_ATTR, (Object)strs[1]);
                data.put(COMMENT_ATTR, (Object)strs[3]);
                json.put(strs[2], (Object)data);
            }
            reader.close();
            System.out.println(JSONObject.toJSONString((Object)json, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void csvToJson() {
        File file = new File(String.valueOf(_DEVPATH.substring(7)) + "/data" + EQUIPT_LIST_PATH);
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int row = 0;
            ArrayList<String> typeList = null;
            ArrayList<String> typeCodes = null;
            LinkedHashMap dataMap = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] strs = line.split(",");
                if (++row == 1) {
                    typeList = new ArrayList<String>();
                    dataMap = new LinkedHashMap();
                    int i = 1;
                    while (i < strs.length) {
                        String str = strs[i].trim();
                        typeList.add(str);
                        dataMap.put(str, new ArrayList());
                        ++i;
                    }
                    continue;
                }
                if (row == 2) {
                    typeCodes = new ArrayList<String>();
                    int i = 1;
                    while (i < strs.length) {
                        String str = strs[i].trim();
                        typeCodes.add(str);
                        ++i;
                    }
                    continue;
                }
                String idCode = strs[0].trim();
                int i = 1;
                while (i < strs.length) {
                    JSONObject data = new JSONObject();
                    data.put("id", "(" + (String)typeCodes.get(i - 1) + ")" + idCode);
                    data.put(LABEL_ATTR, strs[i].trim());
                    String type = (String)typeList.get(i - 1);
                    data.put("type", type);
                    List dataList = (List)dataMap.get(type);
                    dataList.add(data);
                    ++i;
                }
            }
            reader.close();
            JSONObject result = new JSONObject(true);
            int i = 0;
            while (i < typeList.size()) {
                String type = (String)typeList.get(i);
                List dataList = (List)dataMap.get(type);
                int n = 0;
                while (n < dataList.size()) {
                    Map data = (Map)dataList.get(n);
                    String id = (String)data.get("id");
                    if (result.containsKey(id)) {
                        System.out.println(id);
                    }
                    data.remove("id");
                    result.put(id, (Object)data);
                    ++n;
                }
                ++i;
            }
            JSONObject.writeJSONStringTo(result, new FileWriter("D:/Equipt.json"), SerializerFeature.PrettyFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (evt.getSource().equals(this.savIndexCombo)) {
            int savIdx = (Integer)evt.getItem();
            this.loadCharacter(savIdx);
        }
    }

    protected void exit() {
        this.onDestroy();
        this.dispose();
        System.exit(0);
    }

    protected void onDestroy() {
        try {
            ConfigIOUtils.saveConfig(this.appSettings, this.settingsPath);
        }
        catch (IOException e) {
            this.handleError(e, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u51fa\u9519-");
        }
    }

    private static enum GUIAction {
        OpenSav,
        SaveSav,
        CheatAllItem,
        Exit,
        SaveSettings;

    }
}

