/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mhxeditor;

import com.alibaba.fastjson.JSONObject;
import com.zsword.mhxeditor.data.MHXSavDataFile;
import com.zsword.modules.event.CellEditingEvent;
import com.zsword.modules.event.CellEditingListener;
import com.zsword.modules.swing.PanelBase;
import com.zsword.modules.swing.table.ConfigurableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;

class ItemBoxPanel
extends PanelBase
implements ActionListener {
    private static final Map<String, JSONObject> ITEM_COLUMNS = Collections.unmodifiableMap(new LinkedHashMap<String, JSONObject>(){
        {
            this.put("no", JSONObject.parseObject("{label:'\u5e8f\u53f7'}"));
            this.put("item", JSONObject.parseObject("{label:'\u9053\u5177', length:2, editable:true, type:'int', max:1950, min:1}"));
            this.put("count", JSONObject.parseObject("{label:'\u6570\u91cf', length:2, editable:true, type:'int', max:99, min:0}"));
        }
    });
    private JSONObject settings = null;
    private JSONObject lang = null;
    private BoxType listType = null;
    private MHXSavDataFile savFile;
    private JTable dataTable = null;
    private Map<String, Map<String, Object>> dataStruct = null;
    private JLabel statusText = null;
    private JFrame owner = null;

    public ItemBoxPanel(JSONObject settings, JSONObject lang, BoxType listType) {
        this(null, settings, lang, listType);
    }

    public ItemBoxPanel(JFrame owner, JSONObject settings, JSONObject lang, BoxType listType) {
        this.owner = owner;
        this.settings = settings;
        this.lang = lang;
        this.listType = listType;
        this.setLayout(new BorderLayout(5, 5));
        this.initItems();
    }

    protected void initItems() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        JLabel label = new JLabel("\u72b6\u6001:\u65e0");
        toolbar.add(label);
        this.statusText = label;
        this.add((Component)toolbar, "North");
        LinkedHashMap<String, Map<String, Object>> tableDef = new LinkedHashMap<String, Map<String, Object>>();
        switch (this.listType) {
            case CarryItem: 
            case ItemBox: {
                tableDef.putAll(ITEM_COLUMNS);
            }
        }
        JTable table = this.createTable(tableDef);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        this.dataStruct = tableDef;
        this.dataTable = table;
    }

    public void loadDataFile(MHXSavDataFile savFile) throws IOException {
        this.savFile = savFile;
        List<Map<String, Object>> dataList = null;
        switch (this.listType) {
            case CarryItem: {
                dataList = savFile.loadCarryItem(this.dataStruct);
                break;
            }
            case ItemBox: {
                dataList = savFile.loadItemBox(this.dataStruct);
            }
        }
        DefaultTableModel model = (DefaultTableModel)this.dataTable.getModel();
        model.setRowCount(dataList.size());
        int i = 0;
        while (i < dataList.size()) {
            Map<String, Object> data = dataList.get(i);
            this.dataTable.setValueAt(i + 1, i, 0);
            int n = 1;
            while (n < this.dataTable.getColumnCount()) {
                String name = this.dataTable.getColumnName(n);
                Object val = data.get(name);
                this.dataTable.setValueAt(val, i, n);
                ++n;
            }
            ++i;
        }
    }

    private JTable createTable(Map<String, Map<String, Object>> config) {
        ConfigurableTable table = new ConfigurableTable(config);
        table.setRowHeight(25);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(true);
        table.addCellEditingListener(new CellEditingListener(){

            @Override
            public void valueChanged(CellEditingEvent evt) {
                Object val = evt.getNewValue();
                ItemBoxPanel.this.commitEditData(val);
            }
        });
        return table;
    }

    public void addTableSelectionListener(MouseListener l) {
        this.dataTable.addMouseListener(l);
    }

    private void commitEditData(Object val) {
        try {
            int row;
            int idx = row = this.dataTable.getSelectedRow();
            int itemId = -1;
            int itemCount = -1;
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("item".equals(colName)) {
                    itemId = Integer.parseInt(String.valueOf(this.dataTable.getValueAt(row, i)));
                } else if ("count".equals(colName)) {
                    itemCount = (Integer)this.dataTable.getValueAt(row, i);
                }
                ++i;
            }
            if (itemId < 0 || itemCount < 0) {
                throw new IllegalArgumentException("\u6570\u636e\u65e0\u6548-" + itemId + ", " + itemCount);
            }
            switch (this.listType) {
                case ItemBox: {
                    this.savFile.writeBoxItem(idx, itemId, itemCount);
                    break;
                }
                case CarryItem: {
                    this.savFile.writeCarryItem(idx, itemId, itemCount);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleError(e, "\u63d0\u4ea4\u6570\u636e\u4fee\u6539\u51fa\u9519-");
        }
    }

    public TableColumn getSelectedColumn() {
        int col = this.dataTable.getSelectedColumn();
        return this.dataTable.getColumnModel().getColumn(col);
    }

    public String getSelectedCellValueCodeKey() {
        String dataKey = null;
        switch (this.listType) {
            case CarryItem: 
            case ItemBox: {
                dataKey = "";
                break;
            }
        }
        int col = this.dataTable.getSelectedColumn();
        String key = this.dataTable.getColumnName(col);
        if ("equiptId".equals(key)) {
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if (colVal.toString().matches("07|08|09|0A|0B|0C|0D|0E|0F|10|11|12|13|14")) {
                        dataKey = "";
                    }
                    break;
                }
                ++i;
            }
        } else if (key.matches("sharpness|grind")) {
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if ("06".equals(colVal)) {
                        key = "stoneSkill";
                    }
                    break;
                }
                ++i;
            }
        } else if ("insectType".equals(key)) {
            key = null;
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("type".equals(colName)) {
                    int row = this.dataTable.getSelectedRow();
                    Object colVal = this.dataTable.getValueAt(row, i);
                    if ("13".equals(colVal)) {
                        key = "insectType";
                    }
                    break;
                }
                ++i;
            }
        } else if (key.startsWith("decoration")) {
            key = "decoration";
        }
        return String.valueOf(dataKey) + key;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String actName = StringUtils.uncapitalize((String)cmd);
        try {
            Method method = this.getClass().getDeclaredMethod(actName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-" + cmd + ": ");
        }
    }

    public static enum BoxType {
        CarryItem,
        ItemBox;

    }
}

