/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mhxeditor;

import com.alibaba.fastjson.JSONObject;
import com.zsword.mhxeditor.data.MHXSavDataFile;
import com.zsword.modules.event.CellEditingEvent;
import com.zsword.modules.event.CellEditingListener;
import com.zsword.modules.swing.PanelBase;
import com.zsword.modules.swing.table.ConfigurableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;

class CatListPanel
extends PanelBase
implements ActionListener {
    private static final Map<String, JSONObject> DATA_COLUMNS = Collections.unmodifiableMap(new LinkedHashMap<String, JSONObject>(){
        {
            this.put("offset", JSONObject.parseObject("{label:'\u4f4d\u7f6e', renderer:'hex', hidden:true}"));
            this.put("name", JSONObject.parseObject("{label:'\u540d\u5b57', type:'string', length:38, editable:true}"));
            this.put("0unknow", JSONObject.parseObject("{label:'\u672a\u77e5', length:18, hidden:true}"));
            this.put("skill1", JSONObject.parseObject("{label:'\u6280\u80fd1', length:1, editable:true}"));
            this.put("skill2", JSONObject.parseObject("{label:'\u6280\u80fd2', length:1, editable:true}"));
            this.put("skill3", JSONObject.parseObject("{label:'\u6280\u80fd3', length:1, editable:true}"));
            this.put("skill4", JSONObject.parseObject("{label:'\u6280\u80fd4', length:1, editable:true}"));
            this.put("skill5", JSONObject.parseObject("{label:'\u6280\u80fd5', length:1, editable:true}"));
            this.put("skill6", JSONObject.parseObject("{label:'\u6280\u80fd6', length:1, editable:true}"));
            this.put("skill7", JSONObject.parseObject("{label:'\u6280\u80fd7', length:1, editable:true}"));
            this.put("skill8", JSONObject.parseObject("{label:'\u6280\u80fd8', length:1, editable:true}"));
            this.put("skill9", JSONObject.parseObject("{label:'\u6280\u80fd9', length:1, editable:true}"));
            this.put("skill10", JSONObject.parseObject("{label:'\u6280\u80fd10', length:1, editable:true}"));
            this.put("skill11", JSONObject.parseObject("{label:'\u6280\u80fd11', length:1, editable:true}"));
            this.put("skill12", JSONObject.parseObject("{label:'\u6280\u80fd12', length:1, editable:true}"));
            this.put("skill13", JSONObject.parseObject("{label:'\u6280\u80fd13', length:1, editable:true}"));
            this.put("skill14", JSONObject.parseObject("{label:'\u6280\u80fd14', length:1, editable:true}"));
            this.put("skill15", JSONObject.parseObject("{label:'\u6280\u80fd15', length:1, editable:true}"));
            this.put("skill16", JSONObject.parseObject("{label:'\u6280\u80fd16', length:1, editable:true}"));
            this.put("psvskill1", JSONObject.parseObject("{label:'\u88ab\u62801', length:1, editable:true}"));
            this.put("psvskill2", JSONObject.parseObject("{label:'\u88ab\u62802', length:1, editable:true}"));
            this.put("psvskill3", JSONObject.parseObject("{label:'\u88ab\u62803', length:1, editable:true}"));
            this.put("psvskill4", JSONObject.parseObject("{label:'\u88ab\u62804', length:1, editable:true}"));
            this.put("psvskill5", JSONObject.parseObject("{label:'\u88ab\u62805', length:1, editable:true}"));
            this.put("psvskill6", JSONObject.parseObject("{label:'\u88ab\u62806', length:1, editable:true}"));
            this.put("psvskill7", JSONObject.parseObject("{label:'\u88ab\u62807', length:1, editable:true}"));
            this.put("psvskill8", JSONObject.parseObject("{label:'\u88ab\u62808', length:1, editable:true}"));
            this.put("psvskill9", JSONObject.parseObject("{label:'\u88ab\u62809', length:1, editable:true}"));
            this.put("psvskill10", JSONObject.parseObject("{label:'\u88ab\u628010', length:1, editable:true}"));
            this.put("psvskill11", JSONObject.parseObject("{label:'\u88ab\u628011', length:1, editable:true}"));
            this.put("psvskill12", JSONObject.parseObject("{label:'\u88ab\u628012', length:1, editable:true}"));
        }
    });
    private JSONObject settings = null;
    private JSONObject lang = null;
    private MHXSavDataFile savFile;
    private JTable dataTable = null;
    private Map<String, Map<String, Object>> dataStruct = null;
    private JLabel statusText = null;
    private JFrame owner = null;

    public CatListPanel(JSONObject settings, JSONObject lang) {
        this(null, settings, lang);
    }

    public CatListPanel(JFrame owner, JSONObject settings, JSONObject lang) {
        this.owner = owner;
        this.settings = settings;
        this.lang = lang;
        this.setLayout(new BorderLayout(5, 5));
        this.initItems();
    }

    protected void initItems() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        JLabel label = new JLabel("\u72b6\u6001:\u65e0");
        toolbar.add(label);
        this.statusText = label;
        this.add((Component)toolbar, "North");
        LinkedHashMap<String, Map<String, Object>> tableDef = new LinkedHashMap<String, Map<String, Object>>();
        tableDef.putAll(DATA_COLUMNS);
        JTable table = this.createTable(tableDef);
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        this.dataStruct = tableDef;
        this.dataTable = table;
    }

    public void loadDataFile(MHXSavDataFile savFile) throws IOException {
        this.savFile = savFile;
        List<Map<String, Object>> dataList = savFile.loadCatList(this.dataStruct);
        DefaultTableModel model = (DefaultTableModel)this.dataTable.getModel();
        model.setRowCount(dataList.size());
        int i = 0;
        while (i < dataList.size()) {
            Map<String, Object> data = dataList.get(i);
            this.dataTable.setValueAt(i + 1, i, 0);
            int n = 1;
            while (n < this.dataTable.getColumnCount()) {
                String name = this.dataTable.getColumnName(n);
                Object val = data.get(name);
                this.dataTable.setValueAt(val, i, n);
                ++n;
            }
            ++i;
        }
    }

    private JTable createTable(Map<String, Map<String, Object>> config) {
        ConfigurableTable table = new ConfigurableTable(config);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(true);
        table.addCellEditingListener(new CellEditingListener(){

            @Override
            public void valueChanged(CellEditingEvent evt) {
                Object val = evt.getNewValue();
                CatListPanel.this.commitEditData(val);
            }
        });
        return table;
    }

    public void addTableSelectionListener(MouseListener l) {
        this.dataTable.addMouseListener(l);
    }

    private void commitEditData(Object val) {
        try {
            int row = this.dataTable.getSelectedRow();
            int col = this.dataTable.getSelectedColumn();
            String key = this.dataTable.getColumnName(col);
            int addr = -1;
            int i = 0;
            while (i < this.dataTable.getColumnCount()) {
                String colName = this.dataTable.getColumnName(i);
                if ("offset".equals(colName)) {
                    addr = (Integer)this.dataTable.getValueAt(row, i);
                    break;
                }
                ++i;
            }
            if (addr == -1) {
                throw new IllegalArgumentException("\u5730\u5740\u65e0\u6548-" + addr);
            }
            Map<String, Object> def = null;
            Integer len = 0;
            int pos = 0;
            for (String k : this.dataStruct.keySet()) {
                def = this.dataStruct.get(k);
                len = (Integer)def.get("length");
                if (len == null) continue;
                if (k.equals(key)) break;
                pos += len.intValue();
            }
            this.savFile.seek(addr + pos);
            String type = (String)def.get("type");
            if ("string".equals(type)) {
                String encoding = (String)def.get("encoding");
                this.savFile.writeStringData(String.valueOf(val), len, encoding);
                return;
            }
            if (String.class.isAssignableFrom(val.getClass())) {
                val = Integer.parseInt((String)val, 16);
            }
            this.savFile.writeInt((Integer)val, len);
        }
        catch (Exception e) {
            this.handleError(e, "\u63d0\u4ea4\u6570\u636e\u4fee\u6539\u51fa\u9519-");
        }
    }

    public TableColumn getSelectedColumn() {
        int col = this.dataTable.getSelectedColumn();
        return this.dataTable.getColumnModel().getColumn(col);
    }

    public String getSelectedCellValueCodeKey() {
        String dataKey = "Cat-";
        int col = this.dataTable.getSelectedColumn();
        String key = this.dataTable.getColumnName(col);
        if (key.matches("skill\\d*|psvskill\\d*")) {
            key = key.replaceAll("\\d*", "");
        }
        return String.valueOf(dataKey) + key;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String actName = StringUtils.uncapitalize((String)cmd);
        try {
            Method method = this.getClass().getDeclaredMethod(actName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.handleError(e, "\u6267\u884c\u547d\u4ee4\u51fa\u9519-" + cmd + ": ");
        }
    }
}

