/*
 * Decompiled with CFR 0.152.
 */
package com.zsword.mh4geditor.data;

import com.zsword.modules.crypto.provider.Blowfish;
import com.zsword.modules.utils.BitsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class SavedataCipher {
    private static final String BLOWFISH_ALGORITHM = "Blowfish";
    private static final String BLOWFISH_KEY = "blowfish key iorajegqmrna4itjeangmb agmwgtobjteowhv9mope";
    private Blowfish cipher;

    public static void main(String[] args) {
        try {
            SavedataCipher cipher = new SavedataCipher(GameVersion.MH4G_JP);
            File savedataFile = new File("D:/Games/3DS/MHX/mhefqs/examples/n3ds/user3");
            File decryptFile = new File(savedataFile.getParentFile(), String.valueOf(savedataFile.getName()) + "_dec");
            File encryptFile = new File(decryptFile.getParentFile(), String.valueOf(savedataFile.getName()) + "_enc");
            if (savedataFile.getName().endsWith(".temp")) {
                cipher.encryptFile(savedataFile, encryptFile);
                return;
            }
            decryptFile = cipher.decryptFile(savedataFile, decryptFile);
            System.out.println("Decrypt savedata: " + savedataFile.getName() + " to " + decryptFile.getName());
            encryptFile = cipher.encryptFile(decryptFile, encryptFile);
            System.out.println("Encrypt savedata: " + decryptFile.getName() + " to " + encryptFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SavedataCipher(GameVersion version) {
        switch (version) {
            case MH4G_JP: 
            case MH4G_NA: 
            case MH4G_EU: {
                this.cipher = new Blowfish();
                String keyStr = BLOWFISH_KEY;
                this.cipher.init(true, keyStr.getBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("Ivalid game selected.");
            }
        }
    }

    protected byte[] xor(byte[] buff, int pos, int key) {
        int i = pos;
        while (i < buff.length) {
            if (key == 0) {
                key = 1;
            }
            key = key * 176 % 65363;
            int val = this.bytesToInt(new byte[]{buff[i], buff[i + 1]}, false);
            val ^= key;
            val = Integer.reverseBytes(val);
            buff[i] = (byte)(val >> 24);
            buff[i + 1] = (byte)(val >> 16);
            ++i;
            ++i;
        }
        return buff;
    }

    public byte[] encrypt(byte[] buff) throws IOException {
        ByteArrayOutputStream output = null;
        try {
            long seedValue = this.makeLong(buff[3], buff[2], buff[1], buff[0]);
            int seed = (int)(seedValue >> 16);
            int csum = this.sum(buff, 8);
            byte[] data = BitsUtil.intToBytes(csum);
            int i = 0;
            while (i < 4) {
                buff[4 + i] = data[i];
                ++i;
            }
            buff = this.xor(buff, 4, seed);
            data = BitsUtil.intToBytes((seed << 16) + 16);
            output = new ByteArrayOutputStream();
            output.write(data);
            output.write(buff, 4, buff.length - 4);
            buff = output.toByteArray();
            buff = this.byteswap(buff);
            int dataLen = buff.length;
            buff = this.cipher.encrypt(buff);
            if (buff.length > dataLen) {
                buff = Arrays.copyOfRange(buff, buff.length - dataLen, buff.length);
            }
            byte[] byArray = buff = this.byteswap(buff);
            return byArray;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public File encryptFile(File savedata_file, File outFile) throws IOException {
        byte[] savedata = this.readFileData(savedata_file);
        OutputStream output = null;
        try {
            savedata = this.encrypt(savedata);
            output = new FileOutputStream(outFile);
            output.write(savedata);
            output.flush();
            File file = outFile;
            return file;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    protected byte[] decrypt(byte[] buff) {
        buff = this.byteswap(buff);
        buff = this.cipher.decryptBytes(buff, buff.length);
        buff = this.byteswap(buff);
        int seed = (int)(((long)this.bytesToInt(buff, 0, false) & 0xFFFFFFFFL) >> 16);
        int csum = this.bytesToInt(buff = this.xor(buff, 4, seed), 4, false);
        if ((long)csum != ((long)this.sum(buff, 8) & 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Invalid checksum in header.");
        }
        return buff;
    }

    public File decryptFile(File savedataFile, File outFile) throws IOException {
        byte[] savedata = this.readFileData(savedataFile);
        savedata = this.decrypt(savedata);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(outFile);
            ((OutputStream)output).write(savedata);
            output.flush();
            File file = outFile;
            return file;
        }
        finally {
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
    }

    private byte[] byteswap(byte[] buff) {
        int len = buff.length;
        int idx = 0;
        while (idx < len) {
            byte b3;
            byte b0 = buff[idx];
            byte b1 = buff[idx + 1];
            byte b2 = buff[idx + 2];
            buff[idx] = b3 = buff[idx + 3];
            buff[idx + 1] = b2;
            buff[idx + 2] = b1;
            buff[idx + 3] = b0;
            idx += 4;
        }
        return buff;
    }

    private int bytesToInt(byte[] src, boolean bigEndin) {
        return this.bytesToInt(src, 0, bigEndin);
    }

    private int bytesToInt(byte[] src, int start, boolean bigEndin) {
        byte[] temp = new byte[4];
        int idx = 0;
        int i = start;
        while (i < src.length) {
            if (idx > 3) break;
            temp[idx++] = src[i];
            ++i;
        }
        if (!bigEndin) {
            return this.makeInt(temp[3], temp[2], temp[1], temp[0]);
        }
        return this.makeInt(temp[0], temp[1], temp[2], temp[3]);
    }

    private int sum(byte[] buff, int start) {
        int result = 0;
        int i = start;
        while (i < buff.length) {
            result += 0xFF & buff[i];
            ++i;
        }
        return result;
    }

    private int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private long makeLong(byte b3, byte b2, byte b1, byte b0) {
        return ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    private byte[] readFileData(File file) throws IOException {
        ByteArrayOutputStream output = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            output = new ByteArrayOutputStream();
            byte[] buff = new byte[512000];
            int count = -1;
            while ((count = ((InputStream)input).read(buff)) > 0) {
                output.write(buff, 0, count);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private File writeFileData(File file, byte[] data) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            ((OutputStream)output).write(data);
            output.flush();
            File file2 = file;
            return file2;
        }
        finally {
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
    }

    static enum GameVersion {
        MH3G_JP(0),
        MH3G_NA(1),
        MH3G_EU(2),
        MH4_JP(3),
        MH4_NA(4),
        MH4_EU(5),
        MH4G_JP(6),
        MH4G_NA(7),
        MH4G_EU(8),
        MH4G_KR(9);

        private int code;

        private GameVersion(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

